/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui.tests.semantic_highlighter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.Position;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ClassHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ConstantHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.DeprecatedHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.FieldHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.FunctionHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalClassHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalConstantHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.InternalFunctionHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.MethodHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.ParameterVariableHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.StaticFieldHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.StaticMethodHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.SuperGlobalHighlighting;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.php.ui.tests.PHPUiTests;
import org.osgi.framework.Bundle;

public class SemanticHighlightingTests
extends AbstractPDTTTest {
    protected static IProject project;
    protected static IFile testFile;
    protected static PHPVersion phpVersion;
    protected static final Map<PHPVersion, String> TESTS;
    private static Map<String, AbstractSemanticHighlighting> highlighters;

    static {
        TESTS = new LinkedHashMap<PHPVersion, String>();
        TESTS.put(PHPVersion.PHP4, "/workspace/semantic_highlighting/php4");
        TESTS.put(PHPVersion.PHP5, "/workspace/semantic_highlighting/php5");
        TESTS.put(PHPVersion.PHP5_3, "/workspace/semantic_highlighting/php53");
        highlighters = new HashMap<String, AbstractSemanticHighlighting>();
        highlighters.put("class", (AbstractSemanticHighlighting)new ClassHighlighting());
        highlighters.put("constant", (AbstractSemanticHighlighting)new ConstantHighlighting());
        highlighters.put("deprecated", (AbstractSemanticHighlighting)new DeprecatedHighlighting());
        highlighters.put("field", (AbstractSemanticHighlighting)new FieldHighlighting());
        highlighters.put("function", (AbstractSemanticHighlighting)new FunctionHighlighting());
        highlighters.put("internal_class", (AbstractSemanticHighlighting)new InternalClassHighlighting());
        highlighters.put("internal_constant", (AbstractSemanticHighlighting)new InternalConstantHighlighting());
        highlighters.put("internal_function", (AbstractSemanticHighlighting)new InternalFunctionHighlighting());
        highlighters.put("method", (AbstractSemanticHighlighting)new MethodHighlighting());
        highlighters.put("parameter_variable", (AbstractSemanticHighlighting)new ParameterVariableHighlighting());
        highlighters.put("static_field", (AbstractSemanticHighlighting)new StaticFieldHighlighting());
        highlighters.put("static_method", (AbstractSemanticHighlighting)new StaticMethodHighlighting());
        highlighters.put("super_global", (AbstractSemanticHighlighting)new SuperGlobalHighlighting());
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("SemanticHighlighting");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public SemanticHighlightingTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Semantic Highlighting Tests");
        for (Map.Entry<PHPVersion, String> pair : TESTS.entrySet()) {
            String[] files;
            phpVersion = pair.getKey();
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = files = SemanticHighlightingTests.getPDTTFiles((String)pair.getValue(), (Bundle)PHPUiTests.getDefault().getBundle());
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                final String fileName = stringArray[n2];
                try {
                    final PdttFile pdttFile = new PdttFile(PHPUiTests.getDefault().getBundle(), fileName);
                    phpVerSuite.addTest((Test)new SemanticHighlightingTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                        protected void setUp() throws Exception {
                            PHPCoreTests.setProjectPhpVersion((IProject)project, (PHPVersion)PHPVersion.PHP5_3);
                        }

                        protected void tearDown() throws Exception {
                            if (testFile != null) {
                                testFile.delete(true, null);
                                testFile = null;
                            }
                        }

                        protected void runTest() throws Throwable {
                            String result = "";
                            1.createFile(new ByteArrayInputStream(pdttFile.getFile().getBytes()));
                            ISourceModule module = 1.getSourceModule();
                            1.assertNotNull((Object)module);
                            String index = fileName.substring(fileName.lastIndexOf(47) + 1, fileName.indexOf(46));
                            AbstractSemanticHighlighting highlighter = (AbstractSemanticHighlighting)highlighters.get(index);
                            1.assertNotNull((Object)highlighter);
                            Program program = this.getProgram(module);
                            highlighter.initDefaultPreferences();
                            Position[] positions = highlighter.consumes(program);
                            this.assertNoDuplicates(highlighter.getDisplayName(), positions);
                            result = String.valueOf(result) + highlighter.getClass().getName() + ":\n";
                            Position[] positionArray = positions;
                            int n = positions.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Position position = positionArray[n2];
                                result = String.valueOf(result) + "highlight(" + pdttFile.getFile().substring(position.getOffset(), position.getOffset() + position.getLength()) + ")\n";
                                ++n2;
                            }
                            1.assertEquals((String)pdttFile.getExpected(), (String)result);
                            for (AbstractSemanticHighlighting h : highlighters.values()) {
                                if (h == highlighter) continue;
                                h.initDefaultPreferences();
                                positions = h.consumes(program);
                                this.assertNoDuplicates(highlighter.getDisplayName(), positions);
                            }
                        }

                        private Program getProgram(ISourceModule module) throws ModelException, IOException {
                            return SharedASTProvider.getAST((ISourceModule)module, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
                        }
                    });
                }
                catch (Exception e) {
                    phpVerSuite.addTest((Test)new TestCase(fileName){

                        protected void runTest() throws Throwable {
                            throw e;
                        }
                    });
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                SemanticHighlightingTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                SemanticHighlightingTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected void assertNoDuplicates(String highlighter, Position[] positions) {
        Position[] positionArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Position p1 = positionArray[n2];
            Position[] positionArray2 = positions;
            int n3 = positions.length;
            int n4 = 0;
            while (n4 < n3) {
                Position p2 = positionArray2[n4];
                if (p1 != p2 && p1.equals((Object)p2)) {
                    throw new IllegalStateException("Found duplicate position in " + highlighter + ": " + p1);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected static void createFile(InputStream inputStream) throws Exception {
        testFile = project.getFile("test.php");
        testFile.create(inputStream, true, null);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
    }

    protected static ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)testFile);
    }
}

