/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.searchEngine;

import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class PHP53LanguageModelTest
extends TestCase {
    private static IProject project;

    protected void setUp() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("PHPLanguageModelTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
        ProjectOptions.setPhpVersion((PHPVersion)PHPVersion.PHP5_3, (IProject)project);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        PHPCoreTests.waitForAutoBuild();
    }

    protected void tearDown() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public void testBcmath() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("bcsqrt", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    private IDLTKSearchScope createScope() {
        IScriptProject scriptProject = DLTKCore.create((IProject)project);
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        return scope;
    }

    public void testBz2() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("bzopen", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testCalendar() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("jdtogregorian", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testCtype() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("ctype_alnum", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testCurl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("curl_init", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testDate() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("getTimezone", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testDom() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("getTraceAsString", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testExif() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("read_exif_data", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testFilter() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("filter_input", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testFtp() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("ftp_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testGd() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("gd_info", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testGettext() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("dgettext", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testHash() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("hash_file", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testIconv() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("iconv", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testIbm_db2() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("db2_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testImap() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("imap_open", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testIntl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("asort", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testJson() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("json_encode", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testLdap() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("ldap_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testMcrypt() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("mcrypt_cfb", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testMhash() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("mhash_keygen_s2k", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testMime_magic() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("mime_content_type", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testMysql() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("mysql_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testMysqli() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("embedded_server_start", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testOci8() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("tell", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testOpenssl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("openssl_pkey_new", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testPcre() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("preg_match", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testPosix() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("posix_getpid", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testPdo() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("pdo_drivers", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testPgsql() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("pg_connect", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testReflection() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("getClassNames", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testSession() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("session_module_name", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testSimpleXml() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("asXML", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testSoap() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("SoapClient", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testSockets() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("socket_select", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testSpl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("rewind", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testSqlite() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("queryExec", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testStandard() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("bin2hex", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testTidy() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("cleanRepair", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testTokenizer() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("token_name", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testXml() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("xml_set_object", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testXmlreader() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("setRelaxNGSchema", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testXmlwriter() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("setIndent", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testXsl() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("transformToUri", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testZip() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("zip_entry_compressionmethod", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }

    public void testZlib() {
        IDLTKSearchScope scope = this.createScope();
        IMethod[] allFunctions = PhpModelAccess.getDefault().findMethods("gzrewind", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, (IProgressMonitor)new NullProgressMonitor());
        assert (allFunctions.length > 0);
    }
}

