/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.includepath;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.internal.environment.LocalEnvironment;
import org.eclipse.php.internal.core.includepath.IIncludepathListener;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;

public class IncludePathManagerTests
extends TestCase {
    protected IProject project;

    public IncludePathManagerTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        IncludePathManager.getInstance();
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("IncludePathManagerTests");
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
    }

    protected void tearDown() throws Exception {
        this.project.delete(true, null);
    }

    public void testIncludePathGet() throws Exception {
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project);
        scriptProject.setRawBuildpath(new IBuildpathEntry[0], null);
        IncludePath[] includePath = IncludePathManager.getInstance().getIncludePaths(this.project);
        Assert.assertTrue((includePath.length == 0 ? 1 : 0) != 0);
    }

    public void testIncludePathGetAfterBPChange1() throws Exception {
        IFolder folder = this.project.getFolder("a");
        folder.create(true, true, null);
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project);
        scriptProject.setRawBuildpath(new IBuildpathEntry[]{DLTKCore.newSourceEntry((IPath)folder.getFullPath())}, null);
        IncludePath[] includePath = IncludePathManager.getInstance().getIncludePaths(this.project);
        Assert.assertTrue((includePath.length == 0 ? 1 : 0) != 0);
    }

    public void testIncludePathGetAfterBPChange2() throws Exception {
        String libraryPath = "win32".equals(Platform.getOS()) ? "C:\\Projects\\MyLibrary" : "/var/www/MyLibrary";
        IScriptProject scriptProject = DLTKCore.create((IProject)this.project);
        scriptProject.setRawBuildpath(new IBuildpathEntry[]{DLTKCore.newExtLibraryEntry((IPath)EnvironmentPathUtils.getFullPath((IEnvironment)LocalEnvironment.getInstance(), (IPath)new Path(libraryPath)))}, null);
        IncludePath[] includePath = IncludePathManager.getInstance().getIncludePaths(this.project);
        Assert.assertTrue((includePath.length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)includePath[0].isBuildpath());
        Assert.assertEquals((String)EnvironmentPathUtils.getLocalPath((IPath)((IBuildpathEntry)includePath[0].getEntry()).getPath()).toOSString(), (String)libraryPath);
    }

    public void testIncludePathSet() throws Exception {
        IFolder folder = this.project.getFolder("a");
        folder.create(true, true, null);
        folder = folder.getFolder("b");
        folder.create(true, true, null);
        IncludePathManager manager = IncludePathManager.getInstance();
        IncludePath[] includePath = manager.getIncludePaths(this.project);
        int count = includePath.length;
        IncludePath[] includePathArray = includePath;
        includePath = new IncludePath[count + 1];
        System.arraycopy(includePathArray, 0, includePath, 0, count);
        includePath[count] = new IncludePath((Object)folder, this.project);
        this.setIncludePath(manager, includePath);
        includePath = manager.getIncludePaths(this.project);
        Assert.assertTrue((includePath.length == 1 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)includePath[0].isBuildpath());
        Assert.assertEquals((Object)((IResource)includePath[0].getEntry()), (Object)folder);
    }

    private void setIncludePath(IncludePathManager manager, IncludePath[] includePath) {
        IncludePathWaiter waiter = new IncludePathWaiter();
        manager.registerIncludepathListener((IIncludepathListener)waiter);
        manager.setIncludePath(this.project, includePath);
        waiter.run();
        manager.unregisterIncludepathListener((IIncludepathListener)waiter);
    }

    class IncludePathWaiter
    implements IIncludepathListener,
    Runnable {
        private boolean refreshed;

        IncludePathWaiter() {
        }

        public void refresh(IProject project) {
            this.refreshed = true;
        }

        public void run() {
            while (!this.refreshed) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

