/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.dom_ast.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class DomParserTests
extends AbstractPDTTTest {
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();

    static {
        TESTS.put(PHPVersion.PHP4, new String[]{"/workspace/dom_parser/php4"});
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/dom_parser/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/dom_parser/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/dom_parser/php53", "/workspace/dom_parser/php54"});
    }

    public static void setUpSuite() throws Exception {
    }

    public static void tearDownSuite() throws Exception {
    }

    public DomParserTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("DOM Parser Tests");
        for (PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            final ASTParser newParser = ASTParser.newParser((PHPVersion)phpVersion, (boolean)ProjectOptions.useShortTags(null));
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = DomParserTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(fileName);
                        phpVerSuite.addTest((Test)new DomParserTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void runTest() throws Throwable {
                                newParser.setSource(pdttFile.getFile().trim().toCharArray());
                                Program program = newParser.createAST((IProgressMonitor)new NullProgressMonitor());
                                this.assertContents(pdttFile.getExpected(), program.toString());
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                DomParserTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                DomParserTests.tearDownSuite();
            }
        };
        return setup;
    }
}

