/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.compiler_ast.phpdoc;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.php.internal.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.internal.core.compiler.ast.parser.php5.PhpSourceParser;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class PHPDocAwareDeclarationTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(PHPDocAwareDeclarationTests.class);
    }

    public void testVar() throws Exception {
        String str = "<?php  class A { /** My class variable */ var $testVar; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers1() throws Exception {
        String str = "<?php  class A { /** My class variable */ public static $testVarWithModifiers1; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers2() throws Exception {
        String str = "<?php  class A { /** My class variable */ static public $testVarWithModifiers2; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers3() throws Exception {
        String str = "<?php  class A { /** My class variable */ public $testVarWithModifiers3; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers4() throws Exception {
        String str = "<?php  class A { /** My class variable */ private static $testVarWithModifiers4; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers5() throws Exception {
        String str = "<?php  class A { /** My class variable */ static private $testVarWithModifiers5; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers6() throws Exception {
        String str = "<?php  class A { /** My class variable */ private $testVarWithModifiers6; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers7() throws Exception {
        String str = "<?php  class A { /** My class variable */ protected static $testVarWithModifiers7; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers8() throws Exception {
        String str = "<?php  class A { /** My class variable */ static protected $testVarWithModifiers8; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers9() throws Exception {
        String str = "<?php  class A { /** My class variable */ protected $testVarWithModifiers9; } ?>";
        this.parseAndTest(str);
    }

    public void testVarWithModifiers10() throws Exception {
        String str = "<?php  class A { /** My class variable */ static $testVarWithModifiers10; } ?>";
        this.parseAndTest(str);
    }

    public void testClass() throws Exception {
        String str = "<?php  /** Very useful class */ class testClass { } ?>";
        this.parseAndTest(str);
    }

    public void testClassNegative() throws Exception {
        String str = "<?php  /** Very useful class */ ; class testClassNegative { } ?>";
        this.parseAndTest(str, false);
    }

    public void testInterface() throws Exception {
        String str = "<?php  /** Very useful interface */ interface testInterface { } ?>";
        this.parseAndTest(str);
    }

    public void testClassAbstract() throws Exception {
        String str = "<?php  /** Very useful class */ abstract class testClassAbstract { } ?>";
        this.parseAndTest(str);
    }

    public void testClassFinal() throws Exception {
        String str = "<?php  /** Very useful class */ final class testClassFinal { } ?>";
        this.parseAndTest(str);
    }

    public void testMethod() throws Exception {
        String str = "<?php  class A { /** Very useful method */ function testMethod() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers1() throws Exception {
        String str = "<?php  class A { /** Very useful method */ public abstract function testMethodWithModifiers1() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers2() throws Exception {
        String str = "<?php  class A { /** Very useful method */ abstract public function testMethodWithModifiers2() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers3() throws Exception {
        String str = "<?php  class A { /** Very useful method */ public static function testMethodWithModifiers3() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers4() throws Exception {
        String str = "<?php  class A { /** Very useful method */ static public function testMethodWithModifiers4() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers5() throws Exception {
        String str = "<?php  class A { /** Very useful method */ public function testMethodWithModifiers5() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers6() throws Exception {
        String str = "<?php  class A { /** Very useful method */ private abstract function testMethodWithModifiers6() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers7() throws Exception {
        String str = "<?php  class A { /** Very useful method */ abstract private function testMethodWithModifiers7() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers8() throws Exception {
        String str = "<?php  class A { /** Very useful method */ private static function testMethodWithModifiers8() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers9() throws Exception {
        String str = "<?php  class A { /** Very useful method */ static private function testMethodWithModifiers9() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers10() throws Exception {
        String str = "<?php  class A { /** Very useful method */ private function testMethodWithModifiers10() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers11() throws Exception {
        String str = "<?php  class A { /** Very useful method */ protected abstract function testMethodWithModifiers11() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers12() throws Exception {
        String str = "<?php  class A { /** Very useful method */ abstract protected function testMethodWithModifiers12() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers13() throws Exception {
        String str = "<?php  class A { /** Very useful method */ protected static function testMethodWithModifiers13() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers14() throws Exception {
        String str = "<?php  class A { /** Very useful method */ static protected function testMethodWithModifiers14() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers15() throws Exception {
        String str = "<?php  class A { /** Very useful method */ protected function testMethodWithModifiers15() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers16() throws Exception {
        String str = "<?php  class A { /** Very useful method */ abstract function testMethodWithModifiers16() {} } ?>";
        this.parseAndTest(str);
    }

    public void testMethodWithModifiers17() throws Exception {
        String str = "<?php  class A { /** Very useful method */ static function testMethodWithModifiers17() {} } ?>";
        this.parseAndTest(str);
    }

    private void parseAndTest(String str) throws Exception {
        StringReader reader = new StringReader(str);
        String declarationName = new Throwable().fillInStackTrace().getStackTrace()[1].getMethodName();
        this.parseAndTest(reader, declarationName, str, true);
    }

    private void parseAndTest(String str, boolean positiveTest) throws Exception {
        StringReader reader = new StringReader(str);
        String declarationName = new Throwable().fillInStackTrace().getStackTrace()[1].getMethodName();
        this.parseAndTest(reader, declarationName, str, positiveTest);
    }

    public void parseAndTest(Reader reader, String declarationName, String str, boolean positiveTest) throws Exception {
        IModuleDeclaration program = new PhpSourceParser().parse(reader, null, ProjectOptions.useShortTags(null));
        DeclarationSearcher searcher = new DeclarationSearcher(declarationName);
        ((PHPModuleDeclaration)program).traverse((ASTVisitor)searcher);
        Declaration declaration = searcher.getResult();
        Assert.assertNotNull((String)("Can't find declaration AST node for: " + declarationName), (Object)declaration);
        Assert.assertTrue((String)("Declaration is not PHPDoc aware: " + declarationName), (boolean)(declaration instanceof IPHPDocAwareDeclaration));
        PHPDocBlock phpDoc = ((IPHPDocAwareDeclaration)declaration).getPHPDoc();
        if (positiveTest) {
            Assert.assertNotNull((String)("No PHPDoc section found for:" + declarationName), (Object)phpDoc);
            Assert.assertNotNull((String)("PHPDoc doesn't contain short description: " + declarationName), (Object)phpDoc.getShortDescription());
        } else {
            Assert.assertNull((String)("Declaration node: " + declarationName + " must not contain PHPDoc section"), (Object)phpDoc);
        }
    }

    class DeclarationSearcher
    extends ASTVisitor {
        private Declaration declaration;
        private String declarationName;

        public DeclarationSearcher(String declarationName) {
            this.declarationName = declarationName;
        }

        public Declaration getResult() {
            return this.declaration;
        }

        public boolean visit(Declaration d) throws Exception {
            String name = d.getName();
            if (name.startsWith("$")) {
                name = name.substring(1);
            }
            if (name.equals(this.declarationName)) {
                this.declaration = d;
                return false;
            }
            return this.visitGeneral((ASTNode)d);
        }

        public boolean visit(TypeDeclaration s) throws Exception {
            return this.visit((Declaration)s);
        }

        public boolean visit(MethodDeclaration s) throws Exception {
            return this.visit((Declaration)s);
        }

        public boolean visit(Statement s) throws Exception {
            if (s instanceof Declaration) {
                return this.visit((Declaration)s);
            }
            return this.visitGeneral((ASTNode)s);
        }
    }
}

