/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.facet.PHPFacets;
import org.eclipse.php.internal.ui.wizards.IPHPProjectCreateWizardPage;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardFirstPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IPreset;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetsChangedEvent;
import org.eclipse.wst.common.project.facet.core.util.AbstractFilter;
import org.eclipse.wst.common.project.facet.core.util.FilterEvent;
import org.eclipse.wst.common.project.facet.core.util.IFilter;
import org.eclipse.wst.common.project.facet.ui.PresetSelectionPanel;

public class PHPProjectWizardFacetsPage
extends NewElementWizardPage
implements IPHPProjectCreateWizardPage {
    private PHPProjectWizardFirstPage fFirstPage;
    private IFacetedProjectWorkingCopy fpjwc;
    private final IFacetedProjectListener fpjwcListener;
    private IFacetedProjectListener fpjwcListenerForPreset;
    private Composite ppanelParent;
    private PresetSelectionPanel ppanel;
    private TabFolder tabFolder;
    private Composite top;

    public PHPProjectWizardFacetsPage(PHPProjectWizardFirstPage mainPage) {
        super("PHPProjectWizardFacetsPage");
        this.fFirstPage = mainPage;
        this.fpjwcListener = new IFacetedProjectListener(){

            public void handleEvent(IFacetedProjectEvent event) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        PHPProjectWizardFacetsPage.this.validateFacets();
                    }
                };
                PHPProjectWizardFacetsPage.this.getContainer().getShell().getDisplay().asyncExec(runnable);
            }
        };
    }

    protected void createPresetPanel(Composite top) {
        AbstractFilter<IPreset> filter = new AbstractFilter<IPreset>(){
            {
                PHPProjectWizardFacetsPage.this.fpjwcListenerForPreset = new IFacetedProjectListener(){

                    public void handleEvent(IFacetedProjectEvent event) {
                        this.handleProjectFacetsChangedEvent((IProjectFacetsChangedEvent)event);
                    }
                };
            }

            public boolean check(IPreset preset) {
                IProjectFacetVersion primaryFacetVersion = PHPFacets.getCoreVersion();
                return preset.getProjectFacets().contains(primaryFacetVersion);
            }

            private void handleProjectFacetsChangedEvent(IProjectFacetsChangedEvent event) {
                for (IProjectFacetVersion fv : event.getFacetsWithChangedVersions()) {
                    if (fv.getProjectFacet() != PHPFacets.getCoreVersion()) continue;
                    FilterEvent filterEvent = new FilterEvent((IFilter)this, IFilter.IFilterEvent.Type.FILTER_CHANGED);
                    this.notifyListeners((IFilter.IFilterEvent)filterEvent);
                }
                PHPProjectWizardFacetsPage.this.checkTabChanges();
            }
        };
        this.ppanel = new PresetSelectionPanel(top, this.fpjwc, (IFilter)filter);
        this.ppanel.setLayoutData((Object)new GridData(768));
    }

    private void validateFacets() {
        IStatus status = this.fpjwc.validate();
        if (status != null && !status.isOK()) {
            this.setErrorMessage(status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }

    private void checkTabChanges() {
    }

    public void createControl(Composite parent) {
        this.top = this.createTopLevelComposite(parent);
        this.addExtendedControls(this.top);
        this.setControl((Control)this.top);
    }

    private void addExtendedControls(Composite top) {
        this.tabFolder = new TabFolder(top, 0);
        this.tabFolder.setLayoutData((Object)new GridData(768));
        this.tabFolder.setVisible(false);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, true));
        top.setLayoutData((Object)new GridData(1808));
        this.ppanelParent = new Composite(top, 0);
        this.ppanelParent.setLayout((Layout)new GridLayout());
        this.ppanelParent.setLayoutData((Object)new GridData(768));
        return top;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.fpjwc == null) {
            return;
        }
        if (visible) {
            this.internalInit();
        } else {
            this.fpjwc.removeListener(this.fpjwcListener);
            this.fpjwc.removeListener(this.fpjwcListenerForPreset);
            IWizardPage currentPage = this.getContainer().getCurrentPage();
            if (currentPage instanceof IPHPProjectCreateWizardPage) {
                ((IPHPProjectCreateWizardPage)currentPage).initPage();
            }
        }
    }

    private void internalInit() {
        this.fpjwc.addListener(this.fpjwcListener, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.VALIDATION_PROBLEMS_CHANGED});
        this.fpjwc.addListener(this.fpjwcListenerForPreset, new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PROJECT_FACETS_CHANGED});
    }

    public void initPage() {
        IProject project = this.fFirstPage.getProjectHandle();
        try {
            if (this.ppanel != null && !this.ppanel.isDisposed()) {
                this.ppanel.setVisible(false);
                this.ppanel.dispose();
            }
            PHPFacets.createFacetedProject((IProject)project, (PHPVersion)this.fFirstPage.getPHPVersionValue(), (IProgressMonitor)new NullProgressMonitor());
            this.fpjwc = ProjectFacetsManager.create((IProject)project).createWorkingCopy();
            this.createPresetPanel(this.ppanelParent);
            this.checkTabChanges();
            this.top.layout(true);
            this.internalInit();
        }
        catch (CoreException e) {
            PHPCorePlugin.log((Throwable)e);
        }
    }
}

