/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.text.correction.Messages;
import org.eclipse.php.internal.ui.util.StatusInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContributedProcessorDescriptor {
    private final IConfigurationElement fConfigurationElement;
    private Object fProcessorInstance;
    private Boolean fStatus;
    private final Set<String> fHandledMarkerTypes;
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String HANDLED_MARKER_TYPES = "handledMarkerTypes";
    private static final String MARKER_TYPE = "markerType";

    public ContributedProcessorDescriptor(IConfigurationElement element, boolean testMarkerTypes) {
        this.fConfigurationElement = element;
        this.fProcessorInstance = null;
        this.fStatus = null;
        if (this.fConfigurationElement.getChildren("enablement").length == 0) {
            this.fStatus = Boolean.TRUE;
        }
        this.fHandledMarkerTypes = testMarkerTypes ? this.getHandledMarkerTypes(element) : null;
    }

    private Set<String> getHandledMarkerTypes(IConfigurationElement element) {
        HashSet<String> map = new HashSet<String>(7);
        IConfigurationElement[] children = element.getChildren(HANDLED_MARKER_TYPES);
        int i = 0;
        while (i < children.length) {
            IConfigurationElement[] types = children[i].getChildren(MARKER_TYPE);
            int k = 0;
            while (k < types.length) {
                String attribute = types[k].getAttribute(ID);
                if (attribute != null) {
                    map.add(attribute);
                }
                ++k;
            }
            ++i;
        }
        if (map.isEmpty()) {
            map.add("org.eclipse.dltk.core.problem");
            map.add("org.eclipse.dltk.core.buildpath_problem");
            map.add("org.eclipse.dltk.core.task");
        }
        return map;
    }

    public IStatus checkSyntax() {
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length > 1) {
            String id = this.fConfigurationElement.getAttribute(ID);
            return new StatusInfo(4, String.valueOf(Messages.ContributedProcessorDescriptor_4) + id);
        }
        return new StatusInfo(0, Messages.ContributedProcessorDescriptor_5);
    }

    private boolean matches(ISourceModule cunit) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length == 1) {
            try {
                ExpressionConverter parser = ExpressionConverter.getDefault();
                Expression expression = parser.perform(children[0]);
                EvaluationContext evalContext = new EvaluationContext(null, (Object)cunit);
                evalContext.addVariable("compilationUnit", (Object)cunit);
                IScriptProject javaProject = cunit.getScriptProject();
                String[] natures = javaProject.getProject().getDescription().getNatureIds();
                evalContext.addVariable("projectNatures", Arrays.asList(natures));
                return expression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                PHPUiPlugin.log(e);
                return false;
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    public Object getProcessor(ISourceModule cunit, Class<?> expectedType) {
        if (this.matches(cunit)) {
            block5: {
                if (this.fProcessorInstance == null) {
                    try {
                        Object extension = this.fConfigurationElement.createExecutableExtension(CLASS);
                        if (expectedType.isInstance(extension)) {
                            this.fProcessorInstance = extension;
                            break block5;
                        }
                        String message = String.valueOf(Messages.ContributedProcessorDescriptor_8) + this.fConfigurationElement.getName() + Messages.ContributedProcessorDescriptor_9 + expectedType.getName() + "'." + this.fConfigurationElement.getContributor().getName();
                        PHPUiPlugin.log((IStatus)new Status(4, "org.eclipse.php.ui", message));
                        this.fStatus = Boolean.FALSE;
                        return null;
                    }
                    catch (CoreException e) {
                        PHPUiPlugin.log(e);
                        this.fStatus = Boolean.FALSE;
                        return null;
                    }
                }
            }
            return this.fProcessorInstance;
        }
        return null;
    }

    public boolean canHandleMarkerType(String markerType) {
        return this.fHandledMarkerTypes == null || this.fHandledMarkerTypes.contains(markerType);
    }
}

