/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.spelling;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.ui.internal.spelling.ISpellcheckDelegate;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class SpellcheckDelegateAdapterFactory
implements IAdapterFactory {
    private static final Class[] ADAPTER_LIST = new Class[]{ISpellcheckDelegate.class};
    private static final ISpellcheckDelegate DELEGATE = new PHPSpellcheckDelegate();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        ISpellcheckDelegate decision = null;
        if (adaptableObject instanceof IDOMModel && ISpellcheckDelegate.class.equals((Object)adapterType)) {
            decision = DELEGATE;
        }
        return decision;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private static class PHPSpellcheckDelegate
    implements ISpellcheckDelegate {
        private PHPSpellcheckDelegate() {
        }

        public boolean shouldSpellcheck(int offset, IStructuredModel model) {
            IStructuredDocument doc;
            boolean shouldSpellcheck = false;
            if (model instanceof DOMModelForPHP && (doc = ((DOMModelForPHP)model).getStructuredDocument()) instanceof BasicStructuredDocument) {
                IStructuredDocumentRegion sdRegion = ((BasicStructuredDocument)doc).getRegionAtCharacterOffset(offset);
                ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(offset);
                try {
                    if (textRegion instanceof IPhpScriptRegion) {
                        IPhpScriptRegion phpReg = (IPhpScriptRegion)textRegion;
                        String partition = phpReg.getPartition(offset - sdRegion.getStart());
                        if (partition.equals("org.eclipse.php.PHP_QUOTED_STRING") || partition.equals("org.eclipse.php.PHP_COMMENT") || partition.equals("org.eclipse.php.PHP_SINGLE_LINE_COMMENT") || partition.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT") || partition.equals("org.eclipse.php.PHP_DOC")) {
                            shouldSpellcheck = true;
                        }
                    } else {
                        shouldSpellcheck = true;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return shouldSpellcheck;
        }
    }
}

