/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.preferences.CorePreferencesSupport;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.FakeType;
import org.eclipse.php.internal.core.typeinference.UseStatementElement;
import org.eclipse.php.internal.core.util.OutlineFilter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.outline.PHPContentOutlineConfiguration;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PHPOutlineContentProvider
implements ITreeContentProvider {
    private TreeViewer fOutlineViewer;
    private ISourceModule fSourceModule;
    private IModelElement[] fUseStatements;
    private ElementChangedListener fListener;

    public PHPOutlineContentProvider(TreeViewer viewer) {
        this.fOutlineViewer = viewer;
        this.fOutlineViewer.setAutoExpandLevel(-1);
        this.inputChanged((Viewer)this.fOutlineViewer, null, null);
    }

    public void dispose() {
        if (this.fListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
    }

    public Object[] getChildren(Object parent) {
        block3: {
            if (parent instanceof IParent) {
                IParent c = (IParent)parent;
                try {
                    return OutlineFilter.filterChildrenForOutline((Object)parent, (IModelElement[])c.getChildren());
                }
                catch (ModelException x) {
                    if (!DLTKCore.DEBUG && x.isDoesNotExist()) break block3;
                    DLTKUIPlugin.log((Throwable)x);
                }
            }
        }
        return PHPContentOutlineConfiguration.NO_CHILDREN;
    }

    private boolean isNamespaceSupported(IModelElement modelElement) {
        PHPVersion phpVersion = null;
        if (modelElement == null || modelElement.getScriptProject() == null) {
            String versionName = CorePreferencesSupport.getInstance().getWorkspacePreferencesValue("phpVersion");
            phpVersion = PHPVersion.byAlias((String)versionName);
        } else {
            phpVersion = ProjectOptions.getPhpVersion((IProject)modelElement.getScriptProject().getProject());
        }
        return phpVersion.isGreaterThan(PHPVersion.PHP5);
    }

    public Object[] getElements(Object parent) {
        ISourceModule sourceModule;
        Object[] children = this.getChildren(parent);
        if (parent instanceof ISourceModule && this.isNamespaceSupported((IModelElement)(sourceModule = (ISourceModule)parent))) {
            Object[] newChildren = new Object[children.length + 1];
            newChildren[0] = new UseStatementsNode(sourceModule);
            System.arraycopy(children, 0, newChildren, 1, children.length);
            children = newChildren;
        }
        return children;
    }

    public Object getParent(Object child) {
        if (child instanceof IModelElement) {
            IModelElement e = (IModelElement)child;
            return e.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object parent) {
        block4: {
            IModelElement me;
            if (parent instanceof IModelElement && ((me = (IModelElement)parent).getElementType() == 8 || me.getElementType() == 9)) {
                return false;
            }
            if (parent instanceof IParent) {
                IParent c = (IParent)parent;
                try {
                    IModelElement[] children = OutlineFilter.filter((IModelElement[])c.getChildren());
                    return children != null && children.length > 0;
                }
                catch (ModelException x) {
                    if (!DLTKUIPlugin.isDebug() && x.isDoesNotExist()) break block4;
                    DLTKUIPlugin.log((Throwable)x);
                }
            }
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        boolean isCU = newInput instanceof ISourceModule;
        if (isCU && this.fListener == null) {
            this.fListener = new ElementChangedListener();
            DLTKCore.addElementChangedListener((IElementChangedListener)this.fListener);
        } else if (!isCU && this.fListener != null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
    }

    public boolean isDeleted(Object o) {
        return false;
    }

    private IModelElement[] getUseStatements() {
        if (this.fSourceModule == null || !this.fSourceModule.exists()) {
            return new IModelElement[0];
        }
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)this.fSourceModule);
        if (moduleDeclaration == null) {
            return new IModelElement[0];
        }
        UseStatement[] useStatements = ASTUtils.getUseStatements((ModuleDeclaration)moduleDeclaration, (int)moduleDeclaration.sourceEnd());
        LinkedList<UseStatementElement> elements = new LinkedList<UseStatementElement>();
        UseStatement[] useStatementArray = useStatements;
        int n = useStatements.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatement useStatement = useStatementArray[n2];
            for (UsePart usePart : useStatement.getParts()) {
                elements.add(new UseStatementElement((ModelElement)this.fSourceModule, usePart));
            }
            ++n2;
        }
        return elements.toArray(new UseStatementElement[elements.size()]);
    }

    protected class ElementChangedListener
    implements IElementChangedListener {
        private int useStatementsCount;
        private int useStatementsCountNew;

        protected ElementChangedListener() {
        }

        public void elementChanged(final ElementChangedEvent e) {
            final Control control = PHPOutlineContentProvider.this.fOutlineViewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            Job job = new Job(PHPUIMessages.PHPOutlineContentProvider_0){

                protected IStatus run(IProgressMonitor monitor) {
                    Display d;
                    IModelElementDelta delta;
                    IEditorPart activeEditor;
                    IWorkbenchPage activePage;
                    PHPOutlineContentProvider.this.fUseStatements = PHPOutlineContentProvider.this.getUseStatements();
                    IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activeEditor = activePage.getActiveEditor()) instanceof PHPStructuredEditor) {
                        IModelElement base = ((PHPStructuredEditor)activeEditor).getModelElement();
                        if (PHPOutlineContentProvider.this.isNamespaceSupported(base)) {
                            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)((ISourceModule)base));
                            UseStatement[] useStatements = ASTUtils.getUseStatements((ModuleDeclaration)moduleDeclaration, (int)moduleDeclaration.sourceEnd());
                            ElementChangedListener.this.useStatementsCountNew = useStatements.length;
                        }
                    }
                    if (!((delta = ElementChangedListener.this.findElement((IModelElement)PHPOutlineContentProvider.this.fSourceModule, e.getDelta())) == null && e.getType() != 1 || PHPOutlineContentProvider.this.fOutlineViewer == null || PHPOutlineContentProvider.this.fOutlineViewer.getControl() == null || PHPOutlineContentProvider.this.fOutlineViewer.getControl().isDisposed() || (d = control.getDisplay()) == null)) {
                        d.asyncExec(new Runnable(){

                            public void run() {
                                PHPOutlineContentProvider.this.fOutlineViewer.refresh();
                            }
                        });
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(50);
            job.setSystem(true);
            job.schedule();
        }

        protected IModelElementDelta findElement(IModelElement unit, IModelElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 5) {
                return null;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }

        private boolean isPossibleStructuralChange(IModelElementDelta cuDelta) {
            int oldValue = this.useStatementsCount;
            this.useStatementsCount = this.useStatementsCountNew;
            if (oldValue != this.useStatementsCountNew) {
                return true;
            }
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x4001) == 1;
        }
    }

    public class UseStatementsNode
    extends FakeType {
        public UseStatementsNode(ISourceModule sourceModule) {
            super((ModelElement)sourceModule, PHPUIMessages.PHPOutlineContentProvider_useStatementsNode, 0, null);
            PHPOutlineContentProvider.this.fSourceModule = sourceModule;
        }

        public IModelElement[] getChildren() throws ModelException {
            if (PHPOutlineContentProvider.this.fUseStatements == null) {
                PHPOutlineContentProvider.this.fUseStatements = PHPOutlineContentProvider.this.getUseStatements();
            }
            return PHPOutlineContentProvider.this.fUseStatements;
        }

        public boolean hasChildren() throws ModelException {
            return this.getChildren().length > 0;
        }

        public Object getElementInfo() throws ModelException {
            return null;
        }
    }
}

