/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParameter;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.text.hover.CompletionHoverControlCreator;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptOverrideCompletionProposal;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.UseStatementInjector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class PHPOverrideCompletionProposal
extends ScriptOverrideCompletionProposal
implements ICompletionProposalExtension4 {
    private IInformationControlCreator fCreator;

    public PHPOverrideCompletionProposal(IScriptProject jproject, ISourceModule cu, String methodName, String[] paramTypes, int start, int length, String displayName, String completionProposal) {
        super(jproject, cu, methodName, paramTypes, start, length, displayName, completionProposal);
    }

    public void apply(IDocument document, char trigger, int offset) {
        UseStatementInjector injector = new UseStatementInjector((ScriptCompletionProposal)this);
        offset = injector.inject(document, this.getTextViewer(), offset);
        super.apply(document, trigger, offset);
        this.calculateCursorPosition(document, offset);
    }

    public boolean isAutoInsertable() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistAutoinsert", false, null);
    }

    protected boolean insertCompletion() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistInsertCompletion", true, null);
    }

    protected void calculateCursorPosition(IDocument document, int offset) {
        block9: {
            try {
                while (Character.isJavaIdentifierPart(document.getChar(offset)) || document.getChar(offset) == '\\') {
                    ++offset;
                }
                if (document.getChar(offset) != '(') break block9;
                boolean hasArguments = false;
                IModelElement modelElement = this.getModelElement();
                if (modelElement.getElementType() == 9) {
                    IMethod method = (IMethod)modelElement;
                    try {
                        String[] parameters = method.getParameterNames();
                        if (parameters != null && parameters.length > 0) {
                            hasArguments = true;
                        }
                    }
                    catch (ModelException modelException) {}
                }
                if (!hasArguments) {
                    this.setCursorPosition(offset - this.getReplacementOffset() + 2);
                } else {
                    this.setCursorPosition(offset - this.getReplacementOffset() + 1);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public IContextInformation getContextInformation() {
        String infoDisplayString;
        int i;
        String displayString = this.getDisplayString();
        IModelElement modelElement = this.getModelElement();
        if (modelElement instanceof IMethod) {
            IMethod method = (IMethod)modelElement;
            try {
                IParameter[] parameters = method.getParameters();
                if (parameters != null) {
                    StringBuffer sb = new StringBuffer();
                    int i2 = 0;
                    while (i2 < parameters.length) {
                        IParameter parameter = parameters[i2];
                        if (parameter.getType() != null) {
                            sb.append(parameter.getType()).append(" ");
                        }
                        sb.append(parameter.getName());
                        if (parameter.getDefaultValue() != null) {
                            sb.append("=").append(parameter.getDefaultValue());
                        }
                        sb.append(",");
                        ++i2;
                    }
                    String infoDisplayString2 = sb.toString();
                    if (infoDisplayString2.length() > 0) {
                        infoDisplayString2 = infoDisplayString2.substring(0, infoDisplayString2.length() - 1);
                        return new ContextInformation(displayString, infoDisplayString2);
                    }
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
        if ((i = (infoDisplayString = displayString).indexOf(40)) != -1) {
            infoDisplayString = infoDisplayString.substring(i + 1);
        }
        if ((i = infoDisplayString.indexOf(41)) != -1) {
            infoDisplayString = infoDisplayString.substring(0, i);
        }
        if (infoDisplayString.length() == 0) {
            return null;
        }
        return new ContextInformation(displayString, infoDisplayString);
    }

    protected boolean isCamelCaseMatching() {
        return true;
    }

    protected ScriptTextTools getTextTools() {
        return PHPUiPlugin.getDefault().getTextTools();
    }

    public IInformationControlCreator getInformationControlCreator() {
        if (this.fCreator == null) {
            this.fCreator = new CompletionHoverControlCreator(new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, "org.eclipse.dltk.ui.documentationFont", true);
                    }
                    return new DefaultInformationControl(parent, true);
                }
            }, true);
        }
        return this.fCreator;
    }
}

