/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPRuntime;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPsPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewPHPsComboBlock {
    PHPexes exes = PHPexes.getInstance();
    private final List<PHPexeItem> phpExecutables = new ArrayList<PHPexeItem>();
    public static final String PROPERTY_PHP = "PROPERTY_PHP";
    private Composite fControl;
    private Combo fExecutablesCombo;
    private Button fManageButton;
    private ListenerList fListeners = new ListenerList();
    private PHPexeDescriptor fDefaultDescriptor = null;
    private PHPexeDescriptor fSpecificDescriptor = null;
    private Button fDefaultButton = null;
    private Button fSpecificButton = null;
    private String fTitle = null;
    private Button fEnvironmentsButton = null;
    private Combo fEnvironmentsCombo = null;
    private Button fManageEnvironmentsButton = null;
    private IPath fErrorPath;
    private List fEnvironments = new ArrayList();
    private IStatus fStatus = OK_STATUS;
    private static IStatus OK_STATUS = new Status(0, PHPDebugUIPlugin.getID(), 0, "", null);
    private IProject project;
    private final ListenerList fSelectionListeners = new ListenerList();

    public NewPHPsComboBlock() {
        this.fDefaultDescriptor = new PHPexeDescriptor(){

            public String getDescription() {
                PHPexeItem def = PHPDebugPlugin.getPHPexeItem((IProject)NewPHPsComboBlock.this.project);
                return NewPHPsComboBlock.this.getDisplayName(def, true);
            }
        };
        this.setDefaultPHPexeDescriptor(this.fDefaultDescriptor);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void firePropertyChange() {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, PROPERTY_PHP, null, (Object)this.getPHPexe());
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    public void createControl(Composite ancestor) {
        this.fControl = SWTFactory.createComposite((Composite)ancestor, (int)1, (int)1, (int)1808);
        if (this.fTitle == null) {
            this.fTitle = PHPDebugUIMessages.PHPexesComboBlock_3;
        }
        Group group = SWTFactory.createGroup((Composite)this.fControl, (String)this.fTitle, (int)1, (int)1, (int)768);
        Composite comp = SWTFactory.createComposite((Composite)group, (Font)group.getFont(), (int)3, (int)1, (int)1808, (int)0, (int)0);
        this.createDefaultPHPControls(comp);
        this.createEEControls(comp);
        this.createAlternatePHPControls(comp);
        this.setUseDefaultPHP();
    }

    private void createEEControls(Composite comp) {
        this.fEnvironmentsButton = SWTFactory.createRadioButton((Composite)comp, (String)PHPDebugUIMessages.PHPexesComboBlock_4);
        this.fEnvironmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewPHPsComboBlock.this.fEnvironmentsButton.getSelection()) {
                    NewPHPsComboBlock.this.fExecutablesCombo.setEnabled(false);
                    if (NewPHPsComboBlock.this.fEnvironmentsCombo.getText().length() == 0 && !NewPHPsComboBlock.this.fEnvironments.isEmpty()) {
                        NewPHPsComboBlock.this.fEnvironmentsCombo.select(0);
                    }
                    NewPHPsComboBlock.this.fEnvironmentsCombo.setEnabled(true);
                    if (NewPHPsComboBlock.this.fEnvironments.isEmpty()) {
                        NewPHPsComboBlock.this.setError(PHPDebugUIMessages.PHPexesComboBlock_5);
                    } else {
                        NewPHPsComboBlock.this.setStatus(OK_STATUS);
                    }
                    NewPHPsComboBlock.this.firePropertyChange();
                }
            }
        });
        this.fEnvironmentsCombo = SWTFactory.createCombo((Composite)comp, (int)12, (int)1, null);
        this.fEnvironmentsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPHPsComboBlock.this.setPath(PHPRuntime.newPHPContainerPath((PHPVersion)NewPHPsComboBlock.this.getEnvironment()));
                NewPHPsComboBlock.this.firePropertyChange();
            }
        });
        this.fManageEnvironmentsButton = SWTFactory.createPushButton((Composite)comp, (String)PHPDebugUIMessages.PHPexesComboBlock_14, null);
        this.fManageEnvironmentsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewPHPsComboBlock.this.showPrefPage("org.eclipse.php.debug.ui.preferencesphps.PHPExecutionPreferencePreferencePage");
            }
        });
        this.fillWithWorkspaceProfiles();
    }

    private void createAlternatePHPControls(Composite comp) {
        String text = PHPDebugUIMessages.PHPexesComboBlock_1;
        if (this.fSpecificDescriptor != null) {
            text = this.fSpecificDescriptor.getDescription();
        }
        this.fSpecificButton = SWTFactory.createRadioButton((Composite)comp, (String)text, (int)1);
        this.fSpecificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewPHPsComboBlock.this.fSpecificButton.getSelection()) {
                    NewPHPsComboBlock.this.fExecutablesCombo.setEnabled(true);
                    if (NewPHPsComboBlock.this.fExecutablesCombo.getText().length() == 0 && !NewPHPsComboBlock.this.phpExecutables.isEmpty()) {
                        NewPHPsComboBlock.this.fExecutablesCombo.select(0);
                    }
                    if (NewPHPsComboBlock.this.phpExecutables.isEmpty()) {
                        NewPHPsComboBlock.this.setError(PHPDebugUIMessages.PHPexesComboBlock_0);
                    } else {
                        NewPHPsComboBlock.this.setStatus(OK_STATUS);
                    }
                    NewPHPsComboBlock.this.fEnvironmentsCombo.setEnabled(false);
                    NewPHPsComboBlock.this.firePropertyChange();
                }
            }
        });
        this.fExecutablesCombo = SWTFactory.createCombo((Composite)comp, (int)12, (int)1, null);
        ControlAccessibleListener.addListener((Control)this.fExecutablesCombo, this.fSpecificButton.getText());
        this.fExecutablesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewPHPsComboBlock.this.setStatus(OK_STATUS);
                NewPHPsComboBlock.this.firePropertyChange();
            }
        });
        this.fManageButton = SWTFactory.createPushButton((Composite)comp, (String)PHPDebugUIMessages.PHPexesComboBlock_2, null);
        this.fManageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewPHPsComboBlock.this.showPrefPage(PHPsPreferencePage.ID);
            }
        });
        this.fillWithWorkspacePHPexes();
    }

    private void createDefaultPHPControls(Composite comp) {
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton = SWTFactory.createRadioButton((Composite)comp, (String)this.fDefaultDescriptor.getDescription(), (int)3);
            this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (NewPHPsComboBlock.this.fDefaultButton.getSelection()) {
                        NewPHPsComboBlock.this.setUseDefaultPHP();
                        NewPHPsComboBlock.this.setStatus(OK_STATUS);
                        NewPHPsComboBlock.this.firePropertyChange();
                    }
                }
            });
        }
    }

    private void showPrefPage(String id) {
        PHPexeItem prevPHP = this.getPHPexe();
        PHPVersion prevEnv = this.getEnvironment();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, null).open();
        this.fillWithWorkspacePHPexes();
        this.fillWithWorkspaceProfiles();
        this.restoreCombo(this.phpExecutables, prevPHP, this.fExecutablesCombo);
        this.restoreCombo(this.fEnvironments, prevEnv, this.fEnvironmentsCombo);
        this.setDefaultPHPexeDescriptor(this.fDefaultDescriptor);
        if (this.isDefaultPHP()) {
            this.setUseDefaultPHP();
        }
        this.setPath(this.getPath());
        this.firePropertyChange();
    }

    private void restoreCombo(List elements, Object element, Combo combo) {
        int index = -1;
        if (element != null) {
            index = elements.indexOf(element);
        }
        if (index >= 0) {
            combo.select(index);
        } else {
            combo.select(0);
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    private void selectPHP(PHPexeItem vm) {
        int index;
        this.fSpecificButton.setSelection(true);
        this.fDefaultButton.setSelection(false);
        this.fEnvironmentsButton.setSelection(false);
        this.fExecutablesCombo.setEnabled(true);
        this.fEnvironmentsCombo.setEnabled(false);
        if (vm != null && (index = this.phpExecutables.indexOf(vm)) >= 0) {
            this.fExecutablesCombo.select(index);
        }
        this.firePropertyChange();
    }

    private void selectEnvironment(PHPVersion env) {
        int index;
        this.fSpecificButton.setSelection(false);
        this.fDefaultButton.setSelection(false);
        this.fExecutablesCombo.setEnabled(false);
        this.fEnvironmentsButton.setSelection(true);
        this.fEnvironmentsCombo.setEnabled(true);
        if (env != null && (index = this.fEnvironments.indexOf(env)) >= 0) {
            this.fEnvironmentsCombo.select(index);
        }
        this.firePropertyChange();
    }

    private PHPVersion getEnvironment() {
        int index = this.fEnvironmentsCombo.getSelectionIndex();
        if (index >= 0) {
            return (PHPVersion)this.fEnvironments.get(index);
        }
        return null;
    }

    protected void fillWithWorkspaceProfiles() {
        this.fEnvironments.clear();
        PHPVersion[] environments = PHPVersion.values();
        int i = 0;
        while (i < environments.length) {
            this.fEnvironments.add(environments[i]);
            ++i;
        }
        String[] names = new String[this.fEnvironments.size()];
        int i2 = 0;
        while (i2 < names.length) {
            names[i2] = environments[i2].getAlias();
            ++i2;
        }
        this.fEnvironmentsCombo.setItems(names);
        this.fEnvironmentsCombo.setVisibleItemCount(Math.min(names.length, 20));
    }

    public void setDefaultPHPexeDescriptor(PHPexeDescriptor descriptor) {
        this.fDefaultDescriptor = descriptor;
        this.setButtonTextFromDescriptor(this.fDefaultButton, descriptor);
    }

    private void setButtonTextFromDescriptor(Button button, PHPexeDescriptor descriptor) {
        if (button != null) {
            String currentText = button.getText();
            String newText = descriptor.getDescription();
            if (!newText.equals(currentText)) {
                button.setText(newText);
                this.fControl.layout();
            }
        }
    }

    public void setSpecificPHPexeDescriptor(PHPexeDescriptor descriptor) {
        this.fSpecificDescriptor = descriptor;
        this.setButtonTextFromDescriptor(this.fSpecificButton, descriptor);
    }

    public boolean isDefaultPHP() {
        if (this.fDefaultButton != null) {
            return this.fDefaultButton.getSelection();
        }
        return false;
    }

    private void setUseDefaultPHP() {
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton.setSelection(true);
            this.fSpecificButton.setSelection(false);
            this.fEnvironmentsButton.setSelection(false);
            this.fExecutablesCombo.setEnabled(false);
            this.fEnvironmentsCombo.setEnabled(false);
            this.firePropertyChange();
        }
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void refresh() {
        this.setDefaultPHPexeDescriptor(this.fDefaultDescriptor);
    }

    public IPath getPath() {
        if (!this.getStatus().isOK() && this.fErrorPath != null) {
            return this.fErrorPath;
        }
        if (this.fEnvironmentsButton.getSelection()) {
            int index = this.fEnvironmentsCombo.getSelectionIndex();
            if (index >= 0) {
                PHPVersion env = (PHPVersion)this.fEnvironments.get(index);
                return PHPRuntime.newPHPContainerPath((PHPVersion)env);
            }
            return null;
        }
        if (this.fSpecificButton.getSelection()) {
            int index = this.fExecutablesCombo.getSelectionIndex();
            if (index >= 0) {
                PHPexeItem vm = this.phpExecutables.get(index);
                return PHPRuntime.newPHPContainerPath((PHPexeItem)vm);
            }
            return null;
        }
        return PHPRuntime.newDefaultPHPContainerPath();
    }

    public void setPath(IPath containerPath) {
        this.fErrorPath = null;
        this.setStatus(OK_STATUS);
        if (containerPath == null || PHPRuntime.newDefaultPHPContainerPath().equals((Object)containerPath)) {
            this.setUseDefaultPHP();
        } else {
            PHPVersion version = PHPRuntime.getPHPVersion((IPath)containerPath);
            if (version != null) {
                this.selectEnvironment(version);
                PHPexeItem[] items = PHPexes.getInstance().getCompatibleItems(PHPexes.getInstance().getAllItems(), version);
                if (items.length == 0) {
                    this.setError(MessageFormat.format((String)PHPDebugUIMessages.PHPexesComboBlock_7, (Object[])new String[]{version.getAlias()}));
                }
            } else {
                PHPexeItem install = PHPRuntime.getPHPexeItem((IPath)containerPath);
                if (install == null) {
                    this.selectPHP(install);
                    this.fErrorPath = containerPath;
                    this.setError(PHPDebugUIMessages.PHPexesComboBlock_8);
                } else {
                    this.selectPHP(install);
                    File location = install.getExecutable();
                    if (location == null) {
                        this.setError(PHPDebugUIMessages.PHPexesComboBlock_12);
                    } else if (!location.exists()) {
                        this.setError(PHPDebugUIMessages.PHPexesComboBlock_13);
                    }
                }
            }
        }
    }

    public void setProject(IProject project) {
        if (this.project == null || !this.project.equals((Object)project)) {
            this.project = project;
            this.setDefaultPHPexeDescriptor(this.fDefaultDescriptor);
        }
    }

    private void setError(String message) {
        this.setStatus((IStatus)new Status(4, PHPDebugUIPlugin.getID(), 150, message, null));
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    private void setStatus(IStatus status) {
        this.fStatus = status;
    }

    protected void fillWithWorkspacePHPexes() {
        ArrayList<PHPexeItem> standins = new ArrayList<PHPexeItem>();
        PHPexeItem[] phpItems = this.exes.getAllItems();
        if (phpItems != null) {
            int i = 0;
            while (i < phpItems.length) {
                PHPexeItem type = phpItems[i];
                standins.add(type);
                ++i;
            }
        }
        this.setPHPexes(standins);
    }

    protected void setPHPexes(List<PHPexeItem> phps) {
        this.phpExecutables.clear();
        this.phpExecutables.addAll(phps);
        Collections.sort(this.phpExecutables, new Comparator<PHPexeItem>(){

            @Override
            public int compare(PHPexeItem o1, PHPexeItem o2) {
                if (o1 != null && o2 != null) {
                    String o1Name = o1.getName();
                    String o2Name = o2.getName();
                    if (o1Name != null && o2Name != null) {
                        return o1Name.compareToIgnoreCase(o2Name);
                    }
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        String[] names = new String[this.phpExecutables.size()];
        Iterator<PHPexeItem> iter = this.phpExecutables.iterator();
        int i = 0;
        while (iter.hasNext()) {
            PHPexeItem item = iter.next();
            names[i] = this.getDisplayName(item, false);
            ++i;
        }
        if (names.length == 0) {
            names = new String[]{PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined};
        }
        this.fExecutablesCombo.setItems(names);
        PHPexeItem defaultExe = this.exes.getDefaultItem(this.getSelectedDebuggerId());
        if (defaultExe != null) {
            String defaultName = String.valueOf(defaultExe.getName()) + " (" + defaultExe.getExecutable().toString() + ")";
            this.fExecutablesCombo.select(this.fExecutablesCombo.indexOf(defaultName));
        } else {
            this.fExecutablesCombo.select(0);
        }
    }

    private String getDisplayName(PHPexeItem item, boolean isDefault) {
        String name = PHPDebugUIMessages.NewPHPsComboBlock_4;
        if (item != null) {
            String debugger = PHPDebugUIMessages.NewPHPsComboBlock_5;
            if (!"org.eclipse.php.debug.core.zendDebugger".equals(item.getDebuggerID())) {
                debugger = PHPDebugUIMessages.NewPHPsComboBlock_7;
            }
            name = String.valueOf(item.getName()) + " (" + debugger + " " + item.getVersion() + " " + item.getSapiType() + " " + ")";
        }
        if (isDefault) {
            String defaultPrefix = PHPDebugUIMessages.NewPHPsComboBlock_13;
            if (this.project != null) {
                defaultPrefix = PHPDebugUIMessages.NewPHPsComboBlock_14;
            }
            return String.valueOf(defaultPrefix) + PHPDebugUIMessages.NewPHPsComboBlock_15 + name;
        }
        return name;
    }

    public PHPexeItem getPHPexe() {
        return this.getPHPexe(null);
    }

    private PHPexeItem getPHPexe(IProject project) {
        if (this.fSpecificButton.getSelection() && !this.phpExecutables.isEmpty() && this.fExecutablesCombo.getSelectionIndex() >= 0) {
            return this.phpExecutables.get(this.fExecutablesCombo.getSelectionIndex());
        }
        if (this.fEnvironmentsButton.getSelection()) {
            return PHPDebugPlugin.getPHPexeItem((PHPVersion)PHPVersion.byAlias((String)this.fEnvironmentsCombo.getText()));
        }
        return PHPDebugPlugin.getPHPexeItem((IProject)project);
    }

    public PHPexeItem[] getPHPexes() {
        return this.phpExecutables.toArray(new PHPexeItem[this.phpExecutables.size()]);
    }

    public String getSelectedDebuggerId() {
        if (this.fSpecificButton.getSelection() && !this.phpExecutables.isEmpty() && this.fExecutablesCombo.getSelectionIndex() >= 0) {
            return this.phpExecutables.get(this.fExecutablesCombo.getSelectionIndex()).getDebuggerID();
        }
        if (this.fEnvironmentsButton.getSelection()) {
            return PHPDebugPlugin.getCurrentDebuggerId((PHPVersion)PHPVersion.byAlias((String)this.fEnvironmentsCombo.getText()));
        }
        return PHPDebugPlugin.getCurrentDebuggerId();
    }

    public String getSelectedExecutablePath() {
        PHPexeItem item = this.getPHPexe(this.project);
        if (item != null) {
            return item.getExecutable().toString();
        }
        return "";
    }

    public String getSelectedIniPath() {
        PHPexeItem item = this.getPHPexe();
        if (item != null && item.getINILocation() != null) {
            return item.getINILocation().toString();
        }
        return "";
    }
}

