/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.ui.pathmapper.Messages;
import org.eclipse.php.internal.debug.ui.pathmapper.PathMapperEntryDialog;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.IListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class PathMappingComposite
extends Composite {
    private static final int IDX_ADD = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_REMOVE = 2;
    private static final String[] buttonLabels = new String[]{Messages.PathMappingComposite_0, Messages.PathMappingComposite_1, Messages.PathMappingComposite_2};
    private static final String[] columnHeaders = new String[]{Messages.PathMappingComposite_3, Messages.PathMappingComposite_4};
    private static final ColumnLayoutData[] columnLayoutDatas = new ColumnLayoutData[]{new ColumnWeightData(50), new ColumnWeightData(50)};
    private ListDialogField fMapList;

    public PathMappingComposite(Composite parent, int style) {
        super(parent, style);
        this.initializeControls();
    }

    protected void initializeControls() {
        this.fMapList = new ListDialogField((IListAdapter)new ListAdapter(), buttonLabels, (ILabelProvider)new LabelProvider());
        this.fMapList.setRemoveButtonIndex(2);
        this.fMapList.setTableColumns(new ListDialogField.ColumnsDescription(columnLayoutDatas, columnHeaders, true));
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        PixelConverter conv = new PixelConverter((Control)this);
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl((Composite)this, 768);
        scrolledCompositeImpl.setLayout((Layout)layout);
        scrolledCompositeImpl.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)scrolledCompositeImpl, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        scrolledCompositeImpl.setContent((Control)composite);
        scrolledCompositeImpl.setFont(this.getFont());
        GridData data = new GridData(1808);
        data.widthHint = conv.convertWidthInCharsToPixels(50);
        Control listControl = this.fMapList.getListControl(composite);
        listControl.setLayoutData((Object)data);
        Composite buttonsControl = this.fMapList.getButtonBox(composite);
        buttonsControl.setLayoutData((Object)new GridData(258));
        Point size = composite.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(size.x, size.y);
        this.updateButtonsEnablement();
    }

    protected void handleAdd() {
        PathMapperEntryDialog dialog = new PathMapperEntryDialog(this.getShell());
        if (dialog.open() == 0) {
            PathMapper.Mapping mapping = dialog.getResult();
            this.fMapList.addElement((Object)mapping);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fMapList.setEnabled(enabled);
    }

    protected void handleEdit() {
        List l = this.fMapList.getSelectedElements();
        if (l.size() == 1) {
            PathMapper.Mapping oldElement = (PathMapper.Mapping)l.get(0);
            PathMapperEntryDialog dialog = new PathMapperEntryDialog(this.getShell(), oldElement);
            if (dialog.open() == 0) {
                PathMapper.Mapping newElement = dialog.getResult();
                this.fMapList.replaceElement((Object)oldElement, (Object)newElement);
            }
        }
    }

    protected void handleRemove() {
        this.fMapList.removeElements(this.fMapList.getSelectedElements());
    }

    public void setData(Object data) {
        if (!(data instanceof PathMapper.Mapping[])) {
            throw new IllegalArgumentException("Data must be instance of Mapping[]");
        }
        PathMapper.Mapping[] mappings = (PathMapper.Mapping[])data;
        this.fMapList.setElements(Arrays.asList(mappings));
        this.updateButtonsEnablement();
    }

    public PathMapper.Mapping[] getMappings() {
        List l = this.fMapList.getElements();
        return l.toArray(new PathMapper.Mapping[l.size()]);
    }

    protected void updateButtonsEnablement() {
        List selectedElements = this.fMapList.getSelectedElements();
        this.fMapList.enableButton(1, selectedElements.size() == 1);
        this.fMapList.enableButton(2, selectedElements.size() > 0);
    }

    class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ITableLabelProvider {
        private ScriptUILabelProvider phpLabelProvider = new ScriptUILabelProvider();

        LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1) {
                PathMapper.Mapping mapping = (PathMapper.Mapping)element;
                if (mapping.type == PathEntry.Type.EXTERNAL) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                if (mapping.type == PathEntry.Type.INCLUDE_VAR) {
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.envvar_obj.gif");
                }
                if (mapping.type == PathEntry.Type.INCLUDE_FOLDER) {
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.library_obj.gif");
                }
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(mapping.localPath.toString());
                if (resource != null) {
                    return this.phpLabelProvider.getImage((Object)resource);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            PathMapper.Mapping mapping = (PathMapper.Mapping)element;
            switch (columnIndex) {
                case 0: {
                    return mapping.remotePath.toString();
                }
                case 1: {
                    return mapping.localPath.toString();
                }
            }
            return null;
        }
    }

    class ListAdapter
    implements IListAdapter {
        ListAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    PathMappingComposite.this.handleAdd();
                    break;
                }
                case 1: {
                    PathMappingComposite.this.handleEdit();
                    break;
                }
                case 2: {
                    PathMappingComposite.this.handleRemove();
                }
            }
        }

        public void doubleClicked(ListDialogField field) {
            PathMappingComposite.this.handleEdit();
        }

        public void selectionChanged(ListDialogField field) {
            PathMappingComposite.this.updateButtonsEnablement();
        }
    }
}

