/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.model.IPHPDebugTarget;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.actions.EvaluationContextManager;
import org.eclipse.php.internal.debug.ui.views.variables.PHPDebugElementAdapterFactory;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPDebugUIPlugin
extends AbstractUIPlugin {
    private static PHPDebugUIPlugin plugin;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    public static final String ID = "org.eclipse.php.debug.ui";
    public static final int INTERNAL_ERROR = 10001;
    private ShowViewListener showViewListener;
    private TerminateDebugLaunchListener finishDebugLaunchListener;
    private FirstSelectionDebugLaunchListener firstSelectionDebugLaunchListener;
    private IDebugModelPresentation fUtilPresentation;

    public PHPDebugUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.showViewListener = new ShowViewListener();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.showViewListener);
        this.finishDebugLaunchListener = new TerminateDebugLaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.finishDebugLaunchListener);
        this.firstSelectionDebugLaunchListener = new FirstSelectionDebugLaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.firstSelectionDebugLaunchListener);
        AdapterManager manager = (AdapterManager)Platform.getAdapterManager();
        List list = (List)manager.getFactories().get(IVariable.class.getName());
        PHPDebugElementAdapterFactory propertiesFactory = new PHPDebugElementAdapterFactory();
        manager.registerAdapters((IAdapterFactory)propertiesFactory, IVariable.class);
        if (list != null && list.size() > 1) {
            list.remove((Object)propertiesFactory);
            list.add(0, propertiesFactory);
        }
        this.cleanSecuredStorage();
        EvaluationContextManager.startup();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.showViewListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.showViewListener);
        }
        if (this.finishDebugLaunchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.finishDebugLaunchListener);
        }
        if (this.firstSelectionDebugLaunchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.firstSelectionDebugLaunchListener);
        }
        plugin = null;
    }

    public static PHPDebugUIPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return ID;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PHPDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = PHPDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PHPDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void showView(String viewID) {
        IViewPart part;
        IWorkbenchPage page;
        IPerspectiveDescriptor descriptor;
        IWorkbenchWindow window = PHPDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (descriptor = (page = window.getActivePage()).getPerspective()).getId().indexOf("php") != -1 && page != null && (part = page.findView(viewID)) == null) {
            try {
                page.showView(viewID);
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)window.getShell(), (String)PHPDebugUIMessages.ShowView_errorTitle, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    public static void log(IStatus status) {
        PHPDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PHPDebugUIPlugin.log((IStatus)new Status(4, ID, 10001, "PHP ui plugin internal error", e));
    }

    public static IProject getProject(String projectName) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = workspaceRoot.getProjects();
        IProject project = null;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject element = iProjectArray[n2];
            if (element.getName().equals(projectName)) {
                project = element;
                break;
            }
            ++n2;
        }
        return project;
    }

    private void cleanSecuredStorage() {
        Job cleanStorageJob = new Job(PHPDebugUIMessages.PHPDebugUIPlugin_2){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String[] listedHosts;
                    ILaunchConfiguration[] configs;
                    HashMap hostToUsers = new HashMap();
                    ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                    ILaunchConfigurationType configurationType = launchManager.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.webPageLaunch");
                    ILaunchConfiguration[] iLaunchConfigurationArray = configs = launchManager.getLaunchConfigurations(configurationType);
                    int n = configs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                        PHPDebugUIPlugin.this.addTunnelConfiguration(configuration, hostToUsers);
                        ++n2;
                    }
                    ISecurePreferences root = SecurePreferencesFactory.getDefault();
                    ISecurePreferences node = root.node("/org.eclipse.php/DEBUG");
                    String[] stringArray = listedHosts = node.childrenNames();
                    int n3 = listedHosts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ISecurePreferences hostNode;
                        String host = stringArray[n4];
                        if (!hostToUsers.containsKey(host)) {
                            hostNode = node.node(host);
                            hostNode.removeNode();
                        } else if (node.nodeExists(host)) {
                            hostNode = node.node(host);
                            String[] usersKeys = hostNode.keys();
                            List usersList = (List)hostToUsers.get(host);
                            String[] stringArray2 = usersKeys;
                            int n5 = usersKeys.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String userNode = stringArray2[n6];
                                if (!usersList.contains(userNode)) {
                                    hostNode.remove(userNode);
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    Logger.logException("Error while cleaning up the php debug tunnels credentials from the secured storage", e);
                }
                return Status.OK_STATUS;
            }
        };
        cleanStorageJob.setSystem(true);
        cleanStorageJob.setPriority(30);
        cleanStorageJob.schedule(30000L);
    }

    private void addTunnelConfiguration(ILaunchConfiguration configuration, HashMap<String, List<String>> hostToUsers) throws CoreException {
        String userName;
        boolean isUsingTunnel = configuration.getAttribute("org.eclipse.php.debug.core.UseSSHTunnel", false);
        if (isUsingTunnel && (userName = configuration.getAttribute("org.eclipse.php.debug.core.SSHTunnelUserName", "")).length() > 0) {
            String debugHost = PHPLaunchUtilities.getDebugHost((ILaunchConfiguration)configuration);
            List<String> users = hostToUsers.get(debugHost);
            if (users == null) {
                users = new ArrayList<String>(3);
                hostToUsers.put(debugHost, users);
            }
            users.add(userName);
        }
    }

    public IDebugModelPresentation getModelPresentation() {
        if (this.fUtilPresentation == null) {
            this.fUtilPresentation = DebugUITools.newDebugModelPresentation((String)"org.eclipse.php.debug.core");
        }
        return this.fUtilPresentation;
    }

    private static class FirstSelectionDebugLaunchListener
    implements ILaunchesListener2 {
        private FirstSelectionDebugLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] launches) {
        }

        public void launchesAdded(ILaunch[] launches) {
            if (launches != null && launches.length > 0) {
                final ILaunch[] currentLaunches = launches;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (activeWorkbenchWindow == null) {
                            return;
                        }
                        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
                        if (page == null) {
                            return;
                        }
                        LaunchView view = (LaunchView)page.findView("org.eclipse.debug.ui.DebugView");
                        if (view == null) {
                            return;
                        }
                        try {
                            IDebugTarget target = currentLaunches[0].getDebugTarget();
                            if (target == null) {
                                return;
                            }
                            if (target.getThreads() == null || target.getThreads().length == 0) {
                                return;
                            }
                            IThread thread = target.getThreads()[0];
                            IStackFrame frame = thread.getTopStackFrame();
                            if (frame == null) {
                                return;
                            }
                            Object[] segments = new Object[]{DebugPlugin.getDefault().getLaunchManager(), currentLaunches[0], target, thread, frame};
                            TreePath treePath = new TreePath(segments);
                            ((InternalTreeModelViewer)view.getViewer()).setSelection((ISelection)new TreeSelection(treePath), true, true);
                        }
                        catch (DebugException debugException) {}
                    }
                });
            }
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }

    private static class ShowViewListener
    implements IDebugEventSetListener {
        private ShowViewListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            block6: {
                if (events == null) break block6;
                int size = events.length;
                int i = 0;
                while (i < size) {
                    block8: {
                        Object data;
                        Object obj;
                        DebugEvent event;
                        block7: {
                            event = events[i];
                            if (event.getKind() != 4) break block7;
                            obj = events[i].getSource();
                            if (!(obj instanceof IPHPDebugTarget)) break block8;
                            if (PHPDebugPlugin.getOpenDebugViewsOption()) {
                                UIJob job = new UIJob(PHPDebugUIMessages.PHPDebugUIPlugin_0){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        PHPDebugUIPlugin.showView("org.eclipse.debug.ui.PHPBrowserOutput");
                                        PHPDebugUIPlugin.showView("org.eclipse.debug.ui.PHPDebugOutput");
                                        PHPDebugUIPlugin.showView("org.eclipse.ui.console.ConsoleView");
                                        return Status.OK_STATUS;
                                    }
                                };
                                job.schedule();
                            }
                        }
                        if (event.getKind() == 32 && (obj = events[i].getSource()) instanceof IPHPDebugTarget && (data = events[i].getData()) instanceof IStatus) {
                            UIJob job = new UIJob(PHPDebugUIMessages.PHPDebugUIPlugin_0){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    IStatus status = (IStatus)data;
                                    Shell shell = PHPDebugUIPlugin.getActiveWorkbenchShell();
                                    ErrorDialog.openError((Shell)shell, null, null, (IStatus)status);
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static class TerminateDebugLaunchListener
    implements ILaunchesListener2 {
        private TerminateDebugLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] launches) {
            boolean isPHPLaunch = false;
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (launch instanceof PHPLaunch) {
                    isPHPLaunch = true;
                    break;
                }
                ++n2;
            }
            if (!isPHPLaunch) {
                return;
            }
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (!PHPLaunchUtilities.hasPHPDebugLaunch()) {
                        PHPLaunchUtilities.switchToPHPPerspective();
                    }
                }
            });
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
        }
    }
}

