/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.wizards.IPHPExeCompositeFragment;
import org.eclipse.php.internal.debug.ui.wizards.Messages;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.php.internal.ui.wizards.WizardFragmentsFactoryRegistry;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PHPExeEditDialog
extends TitleAreaDialog
implements IControlHandler {
    protected static final String FRAGMENT_GROUP_ID = "org.eclipse.php.debug.ui.phpExeWizardCompositeFragment";
    private List<CompositeFragment> runtimeComposites;
    private PHPexeItem phpExeItem;
    private PHPexeItem[] existingItems;

    public PHPExeEditDialog(Shell shell, PHPexeItem phpExeItem, PHPexeItem[] existingItems) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.existingItems = existingItems;
        this.phpExeItem = phpExeItem;
        this.runtimeComposites = new ArrayList<CompositeFragment>(3);
    }

    public void setDescription(String desc) {
        super.setMessage(desc);
    }

    public PHPexeItem[] getExistingItems() {
        return this.existingItems;
    }

    public void setPHPExeItem(PHPexeItem phpExeItem) {
        this.phpExeItem = phpExeItem;
    }

    public PHPexeItem getPHPExeItem() {
        return this.phpExeItem;
    }

    public void setImageDescriptor(ImageDescriptor image) {
        super.setTitleImage(image.createImage());
    }

    protected Control createDialogArea(Composite parent) {
        ICompositeFragmentFactory[] factories;
        CTabFolder tabs = SWTUtil.createTabFolder((Composite)parent);
        ICompositeFragmentFactory[] iCompositeFragmentFactoryArray = factories = WizardFragmentsFactoryRegistry.getFragmentsFactories((String)FRAGMENT_GROUP_ID);
        int n = factories.length;
        int n2 = 0;
        while (n2 < n) {
            ICompositeFragmentFactory element = iCompositeFragmentFactoryArray[n2];
            CTabItem tabItem = new CTabItem(tabs, 2048);
            CompositeFragment fragment = element.createComposite((Composite)tabs, (IControlHandler)this);
            fragment.setData((Object)this.phpExeItem);
            if (fragment instanceof IPHPExeCompositeFragment) {
                ((IPHPExeCompositeFragment)fragment).setExistingItems(this.existingItems);
            }
            tabItem.setText(fragment.getDisplayName());
            tabItem.setControl((Control)fragment);
            this.runtimeComposites.add(fragment);
            ++n2;
        }
        this.getShell().setText(Messages.PHPExeEditDialog_1);
        tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                CompositeFragment fragment = (CompositeFragment)item.getControl();
                PHPExeEditDialog.this.setTitle(fragment.getTitle());
                PHPExeEditDialog.this.setDescription(fragment.getDescription());
            }
        });
        return tabs;
    }

    protected void cancelPressed() {
        Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            composites.next().performCancel();
        }
        super.cancelPressed();
    }

    protected void okPressed() {
        Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
        while (composites.hasNext()) {
            composites.next().performOk();
        }
        super.okPressed();
    }

    public void update() {
        Button button = this.getButton(0);
        if (button != null) {
            Iterator<CompositeFragment> composites = this.runtimeComposites.iterator();
            while (composites.hasNext()) {
                if (composites.next().isComplete()) continue;
                button.setEnabled(false);
                return;
            }
            button.setEnabled(true);
        }
    }

    public void setMessage(String newMessage, int newType) {
        if (newType == 2) {
            newType = 1;
        }
        super.setMessage(newMessage, newType);
    }
}

