/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import org.eclipse.php.internal.core.util.Messages;

public class UnixChmodUtil {
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;

    public static boolean chmod(String file, int mode) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            throw new IllegalAccessError(Messages.UnixChmodUtil_0);
        }
        boolean status = true;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process p = runtime.exec(new String[]{"chmod", Integer.toString(mode, 8), file});
            status = p.waitFor() == 0;
        }
        catch (Exception exception) {
            status = false;
        }
        return status;
    }
}

