/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.Messages;

public class FunctionOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "FunctionOccurrencesFinder";
    private String functionName;
    private ASTNode erroneousNode;
    private Identifier nameNode;
    private Map<Identifier, String> nodeToFullName = new HashMap<Identifier, String>();

    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.fProblems = FunctionOccurrencesFinder.getProblems(root);
        if (node.getType() == 33) {
            this.nameNode = (Identifier)node;
            if (this.nameNode.getParent() instanceof NamespaceName) {
                this.nameNode = (NamespaceName)this.nameNode.getParent();
            }
            this.functionName = this.nameNode.getName();
            if (this.hasProblems(node.getStart(), node.getEnd())) {
                this.erroneousNode = node;
            }
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    protected void findOccurrences() {
        this.fDescription = Messages.format(BASE_DESCRIPTION, String.valueOf(this.functionName) + "()");
        if (this.erroneousNode != null) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(this.erroneousNode.getStart(), this.erroneousNode.getLength(), this.getOccurrenceType(this.erroneousNode), this.fDescription));
        } else {
            this.fASTRoot.accept(this);
            if (this.nodeToFullName.containsKey(this.nameNode)) {
                String fullName = this.nodeToFullName.get(this.nameNode);
                for (Identifier nameNode : this.nodeToFullName.keySet()) {
                    if (!this.nodeToFullName.get(nameNode).equals(fullName)) continue;
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(nameNode.getStart(), nameNode.getLength(), this.getOccurrenceType(nameNode), this.fDescription));
                }
            }
        }
    }

    public boolean visit(FunctionDeclaration functionDeclaration) {
        ASTNode parent = functionDeclaration.getParent();
        while (parent.getType() == 6 || parent.getType() == 29) {
            parent = parent.getParent();
        }
        if (parent.getType() != 42) {
            Identifier name = functionDeclaration.getFunctionName();
            String fullName = FunctionOccurrencesFinder.getFullName(name, (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace);
            this.nodeToFullName.put(name, fullName);
        }
        return true;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        Expression functionName = functionInvocation.getFunctionName().getName();
        int invocationParent = functionInvocation.getParent().getType();
        if ((functionName.getType() == 33 || functionName.getType() == 65) && invocationParent != 43 && invocationParent != 53) {
            Identifier identifier = (Identifier)functionName;
            String fullName = FunctionOccurrencesFinder.getFullName(identifier, (Map<String, UseStatementPart>)this.fLastUseParts, this.fCurrentNamespace);
            this.nodeToFullName.put(identifier, fullName);
        }
        return true;
    }

    protected int getOccurrenceType(ASTNode node) {
        return 2;
    }

    public String getElementName() {
        return this.functionName;
    }

    public String getID() {
        return ID;
    }
}

