/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phar;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.php.internal.core.phar.AbstractFileExporter;
import org.eclipse.php.internal.core.phar.IStub;
import org.eclipse.php.internal.core.phar.PharPackage;
import org.eclipse.php.internal.core.phar.PharUtil;
import org.eclipse.php.internal.core.tar.CBZip2OutputStreamForPhar;
import org.eclipse.php.internal.core.tar.TarEntry;
import org.eclipse.php.internal.core.tar.TarOutputStream;

public class TarFileExporter
extends AbstractFileExporter {
    private TarOutputStream outputStream;

    public TarFileExporter(PharPackage pharPackage) throws IOException {
        super(pharPackage);
        OutputStream os = this.fileContentStream;
        if (2 == pharPackage.getCompressType()) {
            os = new CBZip2OutputStreamForPhar(os);
        } else if (1 == pharPackage.getCompressType()) {
            os = new GZIPOutputStream(os);
        }
        this.outputStream = new TarOutputStream(os);
    }

    public void finished() throws IOException {
        this.outputStream.close();
    }

    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        URI location;
        ResourceAttributes attributes;
        TarEntry newEntry = new TarEntry(destinationPath);
        if (resource.getLocalTimeStamp() != -1L) {
            newEntry.setTime(resource.getLocalTimeStamp() / 1000L);
        }
        if ((attributes = resource.getResourceAttributes()) != null && attributes.isExecutable()) {
            newEntry.setMode(newEntry.getMode() | 0x49L);
        }
        if (attributes != null && attributes.isReadOnly()) {
            newEntry.setMode(newEntry.getMode() & 0xFFFFFFFFFFFFFF6DL);
        }
        if ((location = resource.getLocationURI()) == null) {
            throw new FileNotFoundException(resource.getFullPath().toOSString());
        }
        newEntry.setSize(EFS.getStore((URI)location).fetchInfo().getLength());
        this.write(newEntry, resource.getContents(false));
    }

    public void writeStub(IStub stub) throws IOException, CoreException {
        ByteArrayInputStream stubInput = PharUtil.getStubInputStream(stub);
        TarEntry newEntry = new TarEntry(".phar/stub.php");
        newEntry.setSize(stubInput.available());
        this.write(newEntry, stubInput);
    }

    private void write(TarEntry entry, InputStream contentStream) throws IOException {
        this.outputStream.putNextEntry(entry);
        try {
            int n;
            byte[] readBuffer = new byte[4096];
            while ((n = contentStream.read(readBuffer)) > 0) {
                this.outputStream.write(readBuffer, 0, n);
            }
        }
        finally {
            if (contentStream != null) {
                contentStream.close();
            }
        }
        this.outputStream.closeEntry();
    }

    public void write(IFolder resource, String destinationPath) throws IOException, CoreException {
        URI location;
        ResourceAttributes attributes;
        TarEntry newEntry = new TarEntry(destinationPath);
        if (resource.getLocalTimeStamp() != -1L) {
            newEntry.setTime(resource.getLocalTimeStamp() / 1000L);
        }
        if ((attributes = resource.getResourceAttributes()) != null && attributes.isExecutable()) {
            newEntry.setMode(newEntry.getMode() | 0x49L);
        }
        if (attributes != null && attributes.isReadOnly()) {
            newEntry.setMode(newEntry.getMode() & 0xFFFFFFFFFFFFFF6DL);
        }
        if ((location = resource.getLocationURI()) == null) {
            throw new FileNotFoundException(resource.getFullPath().toOSString());
        }
        this.outputStream.putNextEntry(newEntry);
        this.outputStream.closeEntry();
    }

    public void doWriteSignature() throws IOException {
        byte[] signature = this.fileContentStream.getSignature();
        if (signature != null) {
            signature = PharUtil.getWholeSignature(signature, this.pharPackage);
            TarEntry newEntry = new TarEntry(".phar/signature.php");
            newEntry.setSize(signature.length);
            this.write(newEntry, PharUtil.getInputStream(signature));
        }
    }
}

