/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format.htmlFormatters;

import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPhp;
import org.eclipse.php.internal.core.format.PhpFormatter;
import org.eclipse.php.internal.core.format.htmlFormatters.EmbeddedCSSFormatterNoPHP;
import org.eclipse.php.internal.core.format.htmlFormatters.HTMLElementFormatterNoPHP;
import org.eclipse.php.internal.core.format.htmlFormatters.HTMLFormatterNoPHP;
import org.eclipse.php.internal.core.format.htmlFormatters.HTMLTextFormatterNoPHP;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.w3c.dom.Node;

public class HTMLFormatterNoPHPFactory {
    private static HTMLFormatterNoPHPFactory fInstance = null;
    public int start;
    public int length;

    public static synchronized HTMLFormatterNoPHPFactory getInstance() {
        if (fInstance == null) {
            fInstance = new HTMLFormatterNoPHPFactory();
        }
        return fInstance;
    }

    public IStructuredFormatter createFormatter(Node node, IStructuredFormatPreferences formatPreferences) {
        Object formatter = null;
        switch (node.getNodeType()) {
            case 1: {
                if (node instanceof ElementImplForPhp && ((ElementImplForPhp)((Object)node)).isPhpTag()) {
                    formatter = new PhpFormatter(this.start, this.length);
                    break;
                }
                formatter = new HTMLElementFormatterNoPHP();
                break;
            }
            case 3: {
                if (this.isEmbeddedCSS(node)) {
                    formatter = new EmbeddedCSSFormatterNoPHP();
                    break;
                }
                formatter = new HTMLTextFormatterNoPHP();
                break;
            }
            default: {
                formatter = new HTMLFormatterNoPHP();
            }
        }
        formatter.setFormatPreferences(formatPreferences);
        return formatter;
    }

    private boolean isEmbeddedCSS(Node node) {
        if (node == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        if (parent.getNodeType() != 1) {
            return false;
        }
        String name = parent.getNodeName();
        if (name == null) {
            return false;
        }
        return name.equalsIgnoreCase("STYLE");
    }
}

