/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;

public class PHPDocTagStrategy
extends AbstractCompletionStrategy {
    public static final String[] PHPDOC_TAGS = new String[]{"abstract", "access", "author", "category", "copyright", "deprecated", "example", "final", "filesource", "global", "ignore", "internal", "license", "link", "method", "namespace", "name", "package", "param", "property", "return", "see", "since", "static", "staticvar", "subpackage", "todo", "throws", "tutorial", "uses", "var", "version"};

    public PHPDocTagStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public PHPDocTagStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        if (!(context instanceof PHPDocTagContext)) {
            return;
        }
        PHPDocTagContext tagContext = (PHPDocTagContext)context;
        String tagName = tagContext.getTagName();
        CompletionRequestor requestor = tagContext.getCompletionRequestor();
        SourceRange replaceRange = this.getReplacementRange(tagContext);
        String suffix = "";
        String[] stringArray = PHPDOC_TAGS;
        int n = PHPDOC_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            String nextTag = stringArray[n2];
            if (CodeAssistUtils.startsWithIgnoreCase(nextTag, tagName) && (!requestor.isContextInformationMode() || nextTag.length() == tagName.length())) {
                reporter.reportKeyword(nextTag, suffix, replaceRange);
            }
            ++n2;
        }
    }
}

