/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.markoccurrence;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.PdttFile;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.locator.PhpElementConciliator;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.OccurrencesFinderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrenceTests
extends AbstractPDTTTest {
    protected static final char OFFSET_CHAR = '|';
    protected static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected static IProject project;
    protected static IFile testFile;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/markoccurrence/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/markoccurrence/php5", "/workspace/markoccurrence/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/markoccurrence/php5", "/workspace/markoccurrence/php53", "/workspace/markoccurrence/php54"});
    }

    public static void setUpSuite() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("MarkOccurrenceTests");
        if (project.exists()) {
            return;
        }
        project.create(null);
        project.open(null);
        IProjectDescription desc = project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        project.setDescription(desc, null);
    }

    public static void tearDownSuite() throws Exception {
        project.close(null);
        project.delete(true, true, null);
        project = null;
    }

    public MarkOccurrenceTests(String description) {
        super(description);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Auto Mark Occurrence Tests");
        for (final PHPVersion phpVersion : TESTS.keySet()) {
            TestSuite phpVerSuite = new TestSuite(phpVersion.getAlias());
            String[] stringArray = TESTS.get(phpVersion);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String testsDirectory = stringArray[n2];
                String[] stringArray2 = MarkOccurrenceTests.getPDTTFiles(testsDirectory);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    try {
                        final PdttFile pdttFile = new PdttFile(fileName);
                        phpVerSuite.addTest((Test)new MarkOccurrenceTests(String.valueOf(phpVersion.getAlias()) + " - /" + fileName){

                            protected void setUp() throws Exception {
                                PHPCoreTests.setProjectPhpVersion(project, phpVersion);
                                pdttFile.applyPreferences();
                            }

                            protected void tearDown() throws Exception {
                                if (testFile != null) {
                                    testFile.delete(true, null);
                                    testFile = null;
                                }
                            }

                            protected void runTest() throws Throwable {
                                1.compareProposals(pdttFile.getFile());
                            }
                        });
                    }
                    catch (Exception e) {
                        phpVerSuite.addTest((Test)new TestCase(fileName){

                            protected void runTest() throws Throwable {
                                throw e;
                            }
                        });
                    }
                    ++n4;
                }
                ++n2;
            }
            suite.addTest((Test)phpVerSuite);
        }
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                MarkOccurrenceTests.setUpSuite();
            }

            protected void tearDown() throws Exception {
                MarkOccurrenceTests.tearDownSuite();
            }
        };
        return setup;
    }

    protected static void compareProposals(String data) throws Exception {
        IOccurrencesFinder finder;
        int type;
        int offset = data.lastIndexOf(124);
        if (offset == -1) {
            throw new IllegalArgumentException("Offset character is not set");
        }
        ArrayList<Integer> starts = new ArrayList<Integer>();
        int startIndex = -1;
        while ((startIndex = data.indexOf(37, startIndex + 1)) >= 0) {
            starts.add(startIndex);
        }
        if (starts.size() % 2 != 0) {
            throw new IllegalArgumentException("% must be paired");
        }
        ArrayList<Integer> newStarts = new ArrayList<Integer>();
        int i = 0;
        while (i < starts.size()) {
            int oldstart = (Integer)starts.get(i) - i;
            if (oldstart > offset) {
                --oldstart;
            }
            newStarts.add(oldstart);
            ++i;
        }
        data = data.replaceAll("%", "");
        offset = data.lastIndexOf(124);
        data = String.valueOf(data.substring(0, offset)) + data.substring(offset + 1);
        testFile = project.getFile("test.php");
        testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        project.refreshLocal(2, null);
        project.build(6, null);
        PHPCoreTests.waitForIndexer();
        Program astRoot = MarkOccurrenceTests.createProgramFromSource(testFile);
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, (int)offset, (int)0);
        IOccurrencesFinder.OccurrenceLocation[] locations = null;
        if (selectedNode != null && (selectedNode instanceof Identifier || MarkOccurrenceTests.isScalarButNotInString(selectedNode)) && MarkOccurrenceTests.markOccurrencesOfType(type = PhpElementConciliator.concile((ASTNode)selectedNode)) && (finder = OccurrencesFinderFactory.getOccurrencesFinder((int)type)) != null && finder.initialize(astRoot, selectedNode) == null) {
            locations = finder.getOccurrences();
        }
        MarkOccurrenceTests.compareProposals(locations, newStarts);
    }

    public static boolean markOccurrencesOfType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static boolean isScalarButNotInString(ASTNode node) {
        return node.getType() == 51 && node.getParent().getType() != 47;
    }

    public static Program createProgramFromSource(IFile file) throws Exception {
        ISourceModule source = DLTKCore.createSourceModuleFrom((IFile)file);
        return MarkOccurrenceTests.createProgramFromSource(source);
    }

    public static Program createProgramFromSource(ISourceModule source) throws Exception {
        PHPVersion version = project != null ? ProjectOptions.getPhpVersion((IProject)project) : ProjectOptions.getDefaultPhpVersion();
        ASTParser newParser = ASTParser.newParser((PHPVersion)version, (ISourceModule)source);
        return newParser.createAST(null);
    }

    protected static ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)testFile);
    }

    public static void compareProposals(IOccurrencesFinder.OccurrenceLocation[] proposals, List<Integer> starts) throws Exception {
        proposals = MarkOccurrenceTests.olderLocations(proposals);
        boolean proposalsEqual = true;
        if (proposals.length == starts.size() / 2) {
            int i = 0;
            while (i < proposals.length) {
                if (proposals[i].getOffset() != starts.get(i * 2).intValue() || proposals[i].getOffset() + proposals[i].getLength() != starts.get(i * 2 + 1)) {
                    proposalsEqual = false;
                    break;
                }
                ++i;
            }
        } else if (proposals != null || starts.size() != 0) {
            proposalsEqual = false;
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED COMPLETIONS LIST:\n-----------------------------\n");
            int i = 0;
            while (i < starts.size() / 2) {
                errorBuf.append('[').append(starts.get(i * 2)).append(',').append(starts.get(i * 2 + 1) - starts.get(i * 2)).append(']').append("\n");
                ++i;
            }
            errorBuf.append("\nACTUAL COMPLETIONS LIST:\n-----------------------------\n");
            IOccurrencesFinder.OccurrenceLocation[] occurrenceLocationArray = proposals;
            int n = proposals.length;
            int n2 = 0;
            while (n2 < n) {
                IOccurrencesFinder.OccurrenceLocation p = occurrenceLocationArray[n2];
                errorBuf.append('[').append(p.getOffset()).append(',').append(p.getLength()).append(']').append("\n");
                ++n2;
            }
            MarkOccurrenceTests.fail((String)errorBuf.toString());
        }
    }

    private static IOccurrencesFinder.OccurrenceLocation[] olderLocations(IOccurrencesFinder.OccurrenceLocation[] proposals) {
        if (proposals == null) {
            return new IOccurrencesFinder.OccurrenceLocation[0];
        }
        ArrayList<IOccurrencesFinder.OccurrenceLocation> result = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        int i = 0;
        while (i < proposals.length) {
            result.add(proposals[i]);
            ++i;
        }
        Collections.sort(result, new Comparator<IOccurrencesFinder.OccurrenceLocation>(){

            @Override
            public int compare(IOccurrencesFinder.OccurrenceLocation o1, IOccurrencesFinder.OccurrenceLocation o2) {
                return o1.getOffset() - o2.getOffset();
            }
        });
        return result.toArray(new IOccurrencesFinder.OccurrenceLocation[result.size()]);
    }
}

