/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTParser;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.IVariableBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.ThrowStatement;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.AbstractVisitor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.ui.corext.codemanipulation.StubUtility;
import org.eclipse.php.ui.editor.SharedASTProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGeneration {
    private static final String UNKNOWN_TYPE = UnknownType.INSTANCE.getTypeName();
    public static final String CLASS_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.classbody";
    public static final String INTERFACE_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.interfacebody";
    public static final String ENUM_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.enumbody";
    public static final String ANNOTATION_BODY_TEMPLATE_ID = "org.eclipse.php.ui.editor.templates.php.codetemplates.annotationbody";
    private static final String[] EMPTY = new String[0];

    private CodeGeneration() {
    }

    public static String getCompilationUnitContent(IScriptProject sp, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        return CodeGeneration.getCompilationUnitContent(sp, CodeGeneration.getFileComment(sp, lineDelimiter), typeComment, typeContent, lineDelimiter);
    }

    public static String getCompilationUnitContent(IScriptProject sp, String fileComment, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        return StubUtility.getCompilationUnitContent(sp, fileComment, typeComment, typeContent, lineDelimiter);
    }

    public static String getFileComment(ISourceModule sm, String lineDelimiter) throws CoreException {
        return StubUtility.getFileComment(sm, lineDelimiter);
    }

    public static String getFileComment(IScriptProject sp, String lineDelimiter) throws CoreException {
        return StubUtility.getFileComment(sp, lineDelimiter);
    }

    public static String getTypeComment(IScriptProject sp, String typeQualifiedName, String lineDelimiter) throws CoreException {
        return StubUtility.getTypeComment(sp, typeQualifiedName, EMPTY, lineDelimiter);
    }

    public static String getTypeComment(IScriptProject sp, String typeQualifiedName, String[] typeParameterNames, String lineDelimiter) throws CoreException {
        return StubUtility.getTypeComment(sp, typeQualifiedName, typeParameterNames, lineDelimiter);
    }

    public static String getTypeBody(String typeKind, IScriptProject sp, String typeName, String lineDelim) throws CoreException {
        return StubUtility.getTypeBody(typeKind, sp, typeName, lineDelim);
    }

    public static String getFieldComment(IScriptProject sp, IField field, String lineDelimiter) throws CoreException {
        String fieldName = field.getElementName();
        String fieldType = null;
        Boolean isVar = false;
        try {
            Program program = SharedASTProvider.getAST(field.getSourceModule(), SharedASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
            ASTNode elementAt = program.getElementAt(field.getSourceRange().getOffset());
            ITypeBinding varType = null;
            IVariableBinding resolvedBinding = null;
            if (elementAt instanceof FieldsDeclaration) {
                FieldsDeclaration fieldDeclaration = (FieldsDeclaration)elementAt;
                resolvedBinding = fieldDeclaration.resolveTypeBinding();
                if (resolvedBinding != null) {
                    varType = resolvedBinding.getType();
                }
            } else if (elementAt instanceof Variable) {
                isVar = true;
                Variable varDeclaration = (Variable)elementAt;
                if (varDeclaration.getParent() instanceof Assignment) {
                    Expression expression = ((Assignment)varDeclaration.getParent()).getRightHandSide();
                    varType = expression.resolveTypeBinding();
                    if (expression instanceof Scalar) {
                        Scalar scalar = (Scalar)expression;
                        switch (scalar.getScalarType()) {
                            case 0: {
                                fieldType = "integer";
                                break;
                            }
                            case 2: {
                                fieldType = "string";
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else {
                    varType = varDeclaration.resolveTypeBinding();
                }
            }
            if (fieldType == null && varType != null) {
                fieldType = varType.isAmbiguous() ? "Ambiguous" : varType.getName();
            }
            if (fieldType == null) {
                fieldType = UNKNOWN_TYPE;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (isVar.booleanValue()) {
            return StubUtility.getVarComment(sp, fieldType, fieldName, lineDelimiter);
        }
        return StubUtility.getFieldComment(sp, fieldType, fieldName, lineDelimiter);
    }

    public static String getMethodComment(IScriptProject sp, String declaringTypeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, IMethod overridden, String lineDelimiter, List<String> exceptions) throws CoreException {
        return StubUtility.getMethodComment(sp, declaringTypeName, methodName, paramNames, retTypeSig, EMPTY, overridden, false, lineDelimiter, exceptions);
    }

    public static String getMethodComment(IScriptProject sp, String declaringTypeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, String[] typeParameterNames, IMethod overridden, String lineDelimiter, List<String> exceptions) throws CoreException {
        return StubUtility.getMethodComment(sp, declaringTypeName, methodName, paramNames, retTypeSig, typeParameterNames, overridden, false, lineDelimiter, exceptions);
    }

    public static String getMethodComment(IMethod method, IMethod overridden, String lineDelimiter) throws CoreException {
        String retType = null;
        String[] typeParameterNames = null;
        String[] parameterTypes = null;
        Program program = null;
        try {
            program = SharedASTProvider.getAST(method.getSourceModule(), SharedASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {}
        if (program == null && (program = CodeGeneration.generageProgram(method, program)) == null) {
            return null;
        }
        ASTNode elementAt = program.getElementAt(method.getSourceRange().getOffset());
        if (!(elementAt instanceof MethodDeclaration || elementAt instanceof FunctionDeclaration || elementAt.getParent() instanceof MethodDeclaration)) {
            if ((program = CodeGeneration.generageProgram(method, program)) == null) {
                return null;
            }
            elementAt = program.getElementAt(method.getSourceRange().getOffset());
        }
        if (elementAt.getParent() instanceof MethodDeclaration) {
            elementAt = elementAt.getParent();
        }
        ITypeBinding[] returnTypes = null;
        ITypeBinding[] typeParametersTypes = null;
        IMethodBinding resolvedBinding = null;
        List formalParameters = null;
        if (elementAt instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)elementAt;
            resolvedBinding = methodDeclaration.resolveMethodBinding();
            formalParameters = methodDeclaration.getFunction().formalParameters();
        } else if (elementAt instanceof FunctionDeclaration) {
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)elementAt;
            resolvedBinding = functionDeclaration.resolveFunctionBinding();
            formalParameters = functionDeclaration.formalParameters();
        }
        final ArrayList exceptions = new ArrayList();
        elementAt.accept((Visitor)new AbstractVisitor(){

            public boolean visit(ThrowStatement throwStatement) {
                ITypeBinding type;
                ClassInstanceCreation cic;
                Expression expression = throwStatement.getExpression();
                if (expression instanceof ClassInstanceCreation && (cic = (ClassInstanceCreation)throwStatement.getExpression()).getClassName().getName() instanceof Identifier) {
                    Identifier name = (Identifier)cic.getClassName().getName();
                    exceptions.add(name.getName());
                }
                if (expression instanceof Variable && (type = ((Variable)expression).resolveTypeBinding()) != null) {
                    exceptions.add(type.getName());
                }
                return true;
            }
        });
        ArrayList<String> newExceptions = new ArrayList<String>();
        HashSet<String> exceptionSet = new HashSet<String>();
        for (String exception : exceptions) {
            if (exceptionSet.contains(exception)) continue;
            exceptionSet.add(exception);
            newExceptions.add(exception);
        }
        if (formalParameters != null) {
            parameterTypes = new String[formalParameters.size()];
            int i = 0;
            for (ASTNode node : formalParameters) {
                FormalParameter formalParameter = (FormalParameter)node;
                Expression parameterType = formalParameter.getParameterType();
                if (parameterType != null) {
                    String typeName = ((Identifier)parameterType).getName();
                    parameterTypes[i++] = typeName;
                    continue;
                }
                if (formalParameter.getDefaultValue() != null && formalParameter.getDefaultValue() instanceof Scalar) {
                    Scalar scalar = (Scalar)formalParameter.getDefaultValue();
                    IEvaluatedType simpleType = PHPSimpleTypes.fromString((String)Scalar.getType((int)scalar.getScalarType()));
                    if (simpleType == null) {
                        parameterTypes[i++] = Scalar.getType((int)scalar.getScalarType());
                        continue;
                    }
                    parameterTypes[i++] = simpleType.getTypeName();
                    continue;
                }
                parameterTypes[i++] = UNKNOWN_TYPE;
            }
        }
        StringBuilder returnTypeBuffer = new StringBuilder();
        if (resolvedBinding != null) {
            returnTypes = resolvedBinding.getReturnType();
            if (returnTypes != null && returnTypes.length > 0) {
                List<ITypeBinding> returnTypesList = CodeGeneration.removeDuplicateTypes(returnTypes);
                for (ITypeBinding returnType : returnTypesList) {
                    if (returnType.isUnknown()) {
                        returnTypeBuffer.append("null").append("|");
                        continue;
                    }
                    if (returnType.isAmbiguous()) {
                        returnTypeBuffer.append("Ambiguous").append("|");
                        continue;
                    }
                    returnTypeBuffer.append(returnType.getName()).append("|");
                }
                if (returnTypeBuffer.length() > 0) {
                    retType = returnTypeBuffer.substring(0, returnTypeBuffer.length() - 1);
                }
            }
            if ((typeParametersTypes = resolvedBinding.getParameterTypes()) != null) {
                int i = 0;
                typeParameterNames = new String[typeParametersTypes.length];
                ITypeBinding[] iTypeBindingArray = typeParametersTypes;
                int n = typeParametersTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding type = iTypeBindingArray[n2];
                    typeParameterNames[i++] = type.getName();
                    ++n2;
                }
            }
        }
        String[] paramNames = method.getParameterNames();
        if (formalParameters == null) {
            parameterTypes = new String[paramNames.length];
            int i = 0;
            while (i < paramNames.length) {
                parameterTypes[i] = UNKNOWN_TYPE;
                ++i;
            }
        }
        int i = 0;
        while (i < paramNames.length) {
            if (parameterTypes != null && parameterTypes[i] != null) {
                paramNames[i] = String.valueOf(parameterTypes[i]) + " " + paramNames[i];
            }
            ++i;
        }
        IType declaringType = method.getDeclaringType();
        if (declaringType != null) {
            return StubUtility.getMethodComment(method.getScriptProject(), declaringType.getElementName(), method.getElementName(), paramNames, retType, typeParameterNames, overridden, false, lineDelimiter, newExceptions);
        }
        return StubUtility.getMethodComment(method.getScriptProject(), null, method.getElementName(), paramNames, retType, typeParameterNames, overridden, false, lineDelimiter, newExceptions);
    }

    private static Program generageProgram(IMethod method, Program program) {
        ISourceModule source = method.getSourceModule();
        ASTParser parserForExpected = ASTParser.newParser((PHPVersion)ProjectOptions.getPhpVersion((IProject)source.getScriptProject().getProject()), (ISourceModule)source);
        try {
            parserForExpected.setSource(source);
            program = parserForExpected.createAST((IProgressMonitor)new NullProgressMonitor());
            program.recordModifications();
            program.setSourceModule(source);
        }
        catch (Exception exception) {}
        return program;
    }

    private static List<ITypeBinding> removeDuplicateTypes(ITypeBinding[] returnTypes) {
        ArrayList<ITypeBinding> types = new ArrayList<ITypeBinding>();
        ITypeBinding[] iTypeBindingArray = returnTypes;
        int n = returnTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding type = iTypeBindingArray[n2];
            if (!types.contains(type)) {
                types.add(type);
            }
            ++n2;
        }
        return types;
    }

    public static String getMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, boolean isConstructor, String bodyStatement, String lineDelimiter) throws CoreException {
        return StubUtility.getMethodBodyContent(isConstructor, sp, declaringTypeName, methodName, bodyStatement, lineDelimiter);
    }

    public static String getGetterMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getGetterMethodBodyContent(sp, declaringTypeName, methodName, fieldName, lineDelimiter);
    }

    public static String getSetterMethodBodyContent(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        return StubUtility.getSetterMethodBodyContent(sp, declaringTypeName, methodName, fieldName, paramName, lineDelimiter);
    }

    public static String getGetterComment(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getGetterComment(sp, declaringTypeName, methodName, fieldName, fieldType, bareFieldName, lineDelimiter);
    }

    public static String getSetterComment(IScriptProject sp, String declaringTypeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        return StubUtility.getSetterComment(sp, declaringTypeName, methodName, fieldName, fieldType, paramName, bareFieldName, lineDelimiter);
    }
}

