/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search.text;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.LineElement;

public class ResultVisitor
extends TextSearchRequestor {
    private final List fResult = new LinkedList();
    private final boolean fIsFileSearchOnly;
    private final boolean fSearchInBinaries;
    private final List fCachedMatches = new ArrayList();

    public ResultVisitor(boolean isFileSearchOnly, boolean searchInBinaries) {
        this.fIsFileSearchOnly = isFileSearchOnly;
        this.fSearchInBinaries = searchInBinaries;
    }

    public ResultVisitor() {
        this(false, false);
    }

    public boolean acceptFile(IFile file) throws CoreException {
        if (this.fIsFileSearchOnly) {
            this.fResult.add(new FileMatch(file));
        }
        this.flushMatches();
        return true;
    }

    public boolean reportBinaryFile(IFile file) {
        return this.fSearchInBinaries;
    }

    public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
        this.fCachedMatches.add(new FileMatch(matchRequestor.getFile(), matchRequestor.getMatchOffset(), matchRequestor.getMatchLength(), this.getLineElement(matchRequestor.getMatchOffset(), matchRequestor)));
        return true;
    }

    public void beginReporting() {
        this.fCachedMatches.clear();
    }

    public void endReporting() {
        this.flushMatches();
    }

    public List getResult() {
        return this.fResult;
    }

    public void clear() {
        this.fResult.clear();
    }

    private void flushMatches() {
        if (!this.fCachedMatches.isEmpty()) {
            this.fResult.addAll(this.fCachedMatches);
        }
    }

    private LineElement getLineElement(int offset, TextSearchMatchAccess matchRequestor) {
        int lineNumber = 1;
        int lineStart = 0;
        if (!this.fCachedMatches.isEmpty()) {
            FileMatch last = (FileMatch)this.fCachedMatches.get(this.fCachedMatches.size() - 1);
            LineElement lineElement = last.getLineElement();
            if (lineElement.contains(offset)) {
                return lineElement;
            }
            lineStart = lineElement.getOffset() + lineElement.getLength();
            lineNumber = lineElement.getLine() + 1;
        }
        if (offset < lineStart) {
            return null;
        }
        int i = lineStart;
        int contentLength = matchRequestor.getFileContentLength();
        while (i < contentLength) {
            char ch;
            if ((ch = matchRequestor.getFileContentChar(i++)) != '\n' && ch != '\r') continue;
            if (ch == '\r' && i < contentLength && matchRequestor.getFileContentChar(i) == '\n') {
                ++i;
            }
            if (offset < i) {
                String lineContent = ResultVisitor.getContents(matchRequestor, lineStart, i);
                return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
            }
            ++lineNumber;
            lineStart = i;
        }
        if (offset < i) {
            String lineContent = ResultVisitor.getContents(matchRequestor, lineStart, i);
            return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
        }
        return null;
    }

    private static String getContents(TextSearchMatchAccess matchRequestor, int start, int end) {
        StringBuffer buf = new StringBuffer();
        int i = start;
        while (i < end) {
            char ch = matchRequestor.getFileContentChar(i);
            if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                buf.append(' ');
            } else {
                buf.append(ch);
            }
            ++i;
        }
        return buf.toString();
    }
}

