/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.ui.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeContentProviderRegistry {
    private static final String EXTENSION_POINT = "phpTreeContentProviders";
    private static final String LABEL_PROVIDER = "labelProvider";
    private static final String CONTENT_PROVIDER = "contentProvider";
    private static TreeContentProviderRegistry instance;
    private List<ITreeContentProvider> contentProviders = new ArrayList<ITreeContentProvider>();
    private List<ILabelProvider> labelProviders = new ArrayList<ILabelProvider>();

    private TreeContentProviderRegistry() {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.php.ui", EXTENSION_POINT);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        Object labelProvider;
                        Object execExt = configElement.createExecutableExtension(CONTENT_PROVIDER);
                        if (execExt instanceof ITreeContentProvider) {
                            this.contentProviders.add((ITreeContentProvider)execExt);
                        }
                        if ((labelProvider = configElement.createExecutableExtension(LABEL_PROVIDER)) instanceof ILabelProvider) {
                            this.labelProviders.add((ILabelProvider)labelProvider);
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static synchronized TreeContentProviderRegistry getInstance() {
        if (instance == null) {
            instance = new TreeContentProviderRegistry();
        }
        return instance;
    }

    public List<ITreeContentProvider> getTreeProviders() {
        return this.contentProviders;
    }

    public List<ILabelProvider> getLabelProviders() {
        return this.labelProviders;
    }
}

