/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.NewExampleAction;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class PHPNewWizardMenu
extends ContributionItem {
    private IAction showDlgAction;
    private IAction newProjectAction;
    private IAction newExampleAction;
    private Map actions = new HashMap(21);
    private boolean enabled = true;
    private IWorkbenchWindow window;
    private boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            PHPNewWizardMenu.this.dirty = true;
        }
    };

    public PHPNewWizardMenu(IMenuManager innerMgr, IWorkbenchWindow window, boolean register) {
        this(window);
        this.fillMenu((IContributionManager)innerMgr);
    }

    public PHPNewWizardMenu(IWorkbenchWindow window) {
        this.window = window;
        this.showDlgAction = ActionFactory.NEW.create(window);
        this.newProjectAction = new NewProjectAction(window);
        this.newExampleAction = new NewExampleAction(window);
    }

    private void fillMenu(IContributionManager innerMgr) {
        innerMgr.removeAll();
        if (this.enabled) {
            innerMgr.add(this.newProjectAction);
            String[] actions = null;
            IWorkbenchPage page = this.window.getActivePage();
            if (page != null) {
                actions = ((WorkbenchPage)page).getNewWizardShortcuts();
            }
            if (actions != null) {
                if (actions.length > 0) {
                    innerMgr.add((IContributionItem)new Separator());
                }
                int i = 0;
                while (i < actions.length) {
                    String id = actions[i];
                    IAction action = this.getAction(id);
                    if (action != null && !WorkbenchActivityHelper.filterItem((Object)action)) {
                        innerMgr.add(action);
                    }
                    ++i;
                }
            }
            if (this.hasExamples()) {
                innerMgr.add((IContributionItem)new Separator());
                innerMgr.add(this.newExampleAction);
            }
            innerMgr.add((IContributionItem)new Separator());
            innerMgr.add(this.showDlgAction);
        }
    }

    private IAction getAction(String id) {
        IWizardDescriptor wizardDesc;
        IAction action = (IAction)this.actions.get(id);
        if (action == null && (wizardDesc = WorkbenchPlugin.getDefault().getNewWizardRegistry().findWizard(id)) != null) {
            action = new NewWizardShortcutAction(this.window, wizardDesc);
            this.actions.put(id, action);
            IConfigurationElement element = (IConfigurationElement)wizardDesc.getAdapter(IConfigurationElement.class);
            if (element != null) {
                this.window.getExtensionTracker().registerObject(element.getDeclaringExtension(), (Object)action, 2);
            }
        }
        return action;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setEnabled(boolean enabledValue) {
        this.enabled = enabledValue;
    }

    public void deregisterListeners() {
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IContributionManager)manager);
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].fill(menu, index++);
            ++i;
        }
        this.dirty = false;
    }

    protected boolean registryHasCategory(String categoryId) {
        return WorkbenchPlugin.getDefault().getNewWizardRegistry().findCategory(categoryId) != null;
    }

    private boolean hasExamples() {
        return this.registryHasCategory("org.eclipse.ui.Examples");
    }
}

