/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.IPHPActionDelegator;
import org.eclipse.php.ui.actions.IRenamePHPElementActionFactory;

public class PHPActionDelegatorRegistry {
    private static final String EXTENSION_POINT = "org.eclipse.php.ui.phpActionDelegator";
    private static final String ACTION_ELEMENT = "action";
    private static final String ACTION_ID_ATTRIBUTE = "actionId";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String PRIORITY_ATTRIBUTE = "priority";
    private Map actionDelegators = new HashMap();
    private static PHPActionDelegatorRegistry instance = new PHPActionDelegatorRegistry();

    private PHPActionDelegatorRegistry() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (ACTION_ELEMENT.equals(element.getName())) {
                String actionId = element.getAttribute(ACTION_ID_ATTRIBUTE);
                LinkedList<IConfigurationElement> elementsList = (LinkedList<IConfigurationElement>)this.actionDelegators.get(actionId);
                if (elementsList == null) {
                    elementsList = new LinkedList<IConfigurationElement>();
                }
                elementsList.add(element);
                this.actionDelegators.put(actionId, elementsList);
            }
            ++i;
        }
    }

    public static IPHPActionDelegator getActionDelegator(String id) {
        List elementsList = (List)PHPActionDelegatorRegistry.instance.actionDelegators.get(id);
        IPHPActionDelegator action = null;
        if (elementsList != null) {
            int topPriority = 0;
            for (IConfigurationElement element : elementsList) {
                int currentPriority = Integer.valueOf(element.getAttribute(PRIORITY_ATTRIBUTE));
                if (currentPriority <= topPriority) continue;
                try {
                    action = (IPHPActionDelegator)element.createExecutableExtension(CLASS_ATTRIBUTE);
                    topPriority = currentPriority;
                }
                catch (CoreException e) {
                    Logger.logException((String)(String.valueOf(PHPUIMessages.PHPActionDelegatorRegistry_0) + element.getAttribute(CLASS_ATTRIBUTE)), (Throwable)e);
                }
            }
        }
        return action;
    }

    public static IRenamePHPElementActionFactory getActionDelegatorFactory(String id) {
        List elementsList = (List)PHPActionDelegatorRegistry.instance.actionDelegators.get(id);
        IRenamePHPElementActionFactory action = null;
        if (elementsList != null) {
            int topPriority = 0;
            for (IConfigurationElement element : elementsList) {
                int currentPriority = Integer.valueOf(element.getAttribute(PRIORITY_ATTRIBUTE));
                if (currentPriority <= topPriority) continue;
                try {
                    action = (IRenamePHPElementActionFactory)element.createExecutableExtension(CLASS_ATTRIBUTE);
                    topPriority = currentPriority;
                }
                catch (CoreException e) {
                    Logger.logException((String)(String.valueOf(PHPUIMessages.PHPActionDelegatorRegistry_1) + element.getAttribute(CLASS_ATTRIBUTE)), (Throwable)e);
                }
            }
        }
        return action;
    }
}

