/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.performance;

import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.core.tests.model.AbstractModelTests;
import org.eclipse.php.core.tests.AbstractPDTTTest;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.performance.PHPCorePerformanceTests;
import org.eclipse.php.core.tests.performance.PerformanceMonitor;
import org.eclipse.php.core.tests.performance.ast.locator.PhpElementConciliatorTestWrapper;
import org.eclipse.php.core.tests.performance.codeassist.CodeAssistTestsWrapper;
import org.eclipse.php.core.tests.performance.filenetwork.FileNetworkTestsWrapper;
import org.eclipse.php.core.tests.performance.formatter.FormatterTestsWrapper;
import org.eclipse.php.core.tests.performance.markoccurrence.MarkOccurrenceTestsWrapper;
import org.eclipse.php.core.tests.performance.selection.SelectionEngineTestsWrapper;
import org.eclipse.php.core.tests.performance.typeinference.TypeInferenceTestsWrapper;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.project.ProjectOptions;

public class ProjectSuite
extends AbstractModelTests {
    protected Map map;
    protected PerformanceMonitor perfMonitor;
    public static final String PHP_VERSION = "phpVersion";
    public static final String PROJECT = "project";
    public static final String URL = "url";
    public static final String TYPE = "type";
    public static final String CHANGE_INCLUDE_PATH = "changeIncludePath";
    public static final String INCLUDE_PATH = "includePath";
    public static final String REFERENCED_FILE = "referencedfiles";
    public static final String REFERENCING_FILE = "referencingfiles";

    public ProjectSuite() {
        super("org.eclipse.php.core.performance.tests", "");
    }

    private String getProjectNameWithVersion(Map map) {
        return String.valueOf(map.get(PROJECT).toString()) + "_" + ((PHPVersion)map.get(PHP_VERSION)).getAlias();
    }

    public Test suite(final Map map) {
        this.map = map;
        TestSuite suite = new TestSuite(String.valueOf(this.getProjectNameWithVersion(map)) + " Performance Tests");
        this.addTests(suite);
        TestSetup setup = new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                ProjectSuite.this.deleteProject(map.get(ProjectSuite.PROJECT).toString());
                IProject project = ProjectSuite.getProject((String)map.get(ProjectSuite.PROJECT).toString());
                IScriptProject scriptProject = DLTKCore.create((IProject)project);
                project.create(null);
                project.open(null);
                IProjectDescription desc = project.getDescription();
                desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
                project.setDescription(desc, null);
                ProjectOptions.setPhpVersion((PHPVersion)((PHPVersion)map.get(ProjectSuite.PHP_VERSION)), (IProject)project.getProject());
                IFolder testFolder = project.getFolder("pdttest");
                testFolder.create(true, true, null);
                if (map.get(ProjectSuite.CHANGE_INCLUDE_PATH) != null && ((Boolean)map.get(ProjectSuite.CHANGE_INCLUDE_PATH)).booleanValue()) {
                    String[] includePath = (String[])map.get(ProjectSuite.INCLUDE_PATH);
                    IBuildpathEntry[] buildpathEntries = new IBuildpathEntry[includePath.length + 1];
                    buildpathEntries[buildpathEntries.length - 1] = DLTKCore.newSourceEntry((IPath)testFolder.getFullPath());
                    int i = 0;
                    while (i < includePath.length) {
                        buildpathEntries[i] = DLTKCore.newSourceEntry((IPath)project.getFullPath().append(includePath[i]));
                        ++i;
                    }
                    scriptProject.setRawBuildpath(buildpathEntries, null);
                }
                ProjectSuite.this.perfMonitor = PHPCorePerformanceTests.getPerformanceMonitor();
            }

            protected void tearDown() throws Exception {
                ProjectSuite.this.deleteProject(map.get(ProjectSuite.PROJECT).toString());
            }
        };
        return setup;
    }

    protected void addTests(TestSuite suite) {
        suite.addTest((Test)new BuildProjectTest());
        suite.addTest(new CodeAssistTestsWrapper().suite(this.map));
        suite.addTest(new MarkOccurrenceTestsWrapper().suite(this.map));
        suite.addTest(new PhpElementConciliatorTestWrapper().suite(this.map));
        suite.addTest(new FormatterTestsWrapper().suite(this.map));
        suite.addTest(new SelectionEngineTestsWrapper().suite(this.map));
        suite.addTest(new TypeInferenceTestsWrapper().suite(this.map));
        suite.addTest(new FileNetworkTestsWrapper().suite(this.map));
    }

    public class BuildProjectTest
    extends AbstractPDTTTest {
        public BuildProjectTest() {
            super(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + "_BuildProjectTest");
        }

        public void runTest() throws Throwable {
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(ProjectSuite.this.map.get(ProjectSuite.PROJECT).toString());
            ProjectSuite.this.perfMonitor.execute(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + ".testBuildProject", new PerformanceMonitor.Operation(){

                public void run() throws Exception {
                    project.refreshLocal(2, null);
                    PHPCoreTests.waitForIndexer();
                }
            }, 1, 10);
        }
    }

    public class SearchAllFunctionsTest
    extends AbstractPDTTTest {
        public SearchAllFunctionsTest() {
            super(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + "_SearchAllFunctionsTest");
        }

        public void runTest() throws Throwable {
            final PhpModelAccess modelAccess = PhpModelAccess.getDefault();
            IProject project = ProjectSuite.getProject((String)ProjectSuite.this.map.get(ProjectSuite.PROJECT).toString());
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            final IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            modelAccess.findMethods("", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, null);
            ProjectSuite.this.perfMonitor.execute(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + ".testSearchAllFunctions", new PerformanceMonitor.Operation(){

                public void run() throws Exception {
                    modelAccess.findMethods("", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, null);
                }
            }, 10, 10);
        }
    }

    public class SearchAllTypesTest
    extends AbstractPDTTTest {
        public SearchAllTypesTest() {
            super(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + "_SearchAllTypesTest");
        }

        public void runTest() throws Throwable {
            final PhpModelAccess modelAccess = PhpModelAccess.getDefault();
            IProject project = ProjectSuite.getProject((String)ProjectSuite.this.map.get(ProjectSuite.PROJECT).toString());
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            final IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            modelAccess.findTypes("", ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
            ProjectSuite.this.perfMonitor.execute(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + ".testSearchAllTypes", new PerformanceMonitor.Operation(){

                public void run() throws Exception {
                    modelAccess.findTypes("", ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
                }
            }, 10, 10);
        }
    }

    public class SearchGlobalVariablesTest
    extends AbstractPDTTTest {
        public SearchGlobalVariablesTest() {
            super(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + "_SearchGlobalVariablesTest");
        }

        public void runTest() throws Throwable {
            final PhpModelAccess modelAccess = PhpModelAccess.getDefault();
            IProject project = ProjectSuite.getProject((String)ProjectSuite.this.map.get(ProjectSuite.PROJECT).toString());
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            final IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            modelAccess.findFields("", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, null);
            ProjectSuite.this.perfMonitor.execute(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + ".testSearchGlobalVariables", new PerformanceMonitor.Operation(){

                public void run() throws Exception {
                    modelAccess.findFields("", ISearchEngine.MatchRule.PREFIX, 8192, 0, scope, null);
                }
            }, 10, 10);
        }
    }

    public class SearchIncludeStatementsTest
    extends AbstractPDTTTest {
        public SearchIncludeStatementsTest() {
            super(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + "_SearchIncludeStatementsTest");
        }

        public void runTest() throws Throwable {
            final PhpModelAccess modelAccess = PhpModelAccess.getDefault();
            IProject project = ProjectSuite.getProject((String)ProjectSuite.this.map.get(ProjectSuite.PROJECT).toString());
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            final IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            modelAccess.findIncludes("", ISearchEngine.MatchRule.PREFIX, scope, null);
            ProjectSuite.this.perfMonitor.execute(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + ".testSearchIncludeStatements", new PerformanceMonitor.Operation(){

                public void run() throws Exception {
                    modelAccess.findIncludes("", ISearchEngine.MatchRule.PREFIX, scope, null);
                }
            }, 10, 10);
        }
    }

    public class SuperTypeHierarchyTest
    extends AbstractPDTTTest {
        public SuperTypeHierarchyTest() {
            super(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + "_SuperTypeHierarchyTest");
        }

        public void runTest() throws Throwable {
            IProject project = ProjectSuite.getProject((String)ProjectSuite.this.map.get(ProjectSuite.PROJECT).toString());
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            final IType[] exceptionType = PhpModelAccess.getDefault().findTypes(ProjectSuite.this.map.get(ProjectSuite.TYPE).toString(), ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            Assert.assertNotNull((Object)exceptionType);
            Assert.assertEquals((int)exceptionType.length, (int)1);
            ProjectSuite.this.perfMonitor.execute(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + ".testSuperTypeHierarchy", new PerformanceMonitor.Operation(){

                public void run() throws Exception {
                    exceptionType[0].newSupertypeHierarchy(null);
                }
            }, 10, 10);
        }
    }

    public class TypeHierarchyTest
    extends AbstractPDTTTest {
        public TypeHierarchyTest() {
            super(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + "_TypeHierarchyTest");
        }

        public void runTest() throws Throwable {
            IProject project = ProjectSuite.getProject((String)ProjectSuite.this.map.get(ProjectSuite.PROJECT).toString());
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
            final IType[] exceptionType = PhpModelAccess.getDefault().findTypes(ProjectSuite.this.map.get(ProjectSuite.TYPE).toString(), ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            Assert.assertNotNull((Object)exceptionType);
            Assert.assertEquals((int)exceptionType.length, (int)1);
            ProjectSuite.this.perfMonitor.execute(String.valueOf(ProjectSuite.this.getProjectNameWithVersion(ProjectSuite.this.map)) + ".testTypeHierarchy", new PerformanceMonitor.Operation(){

                public void run() throws Exception {
                    exceptionType[0].newTypeHierarchy(null);
                }
            }, 10, 10);
        }
    }
}

