/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.io.CharArrayReader;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.formatter.core.CodeFormatterPreferences;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class PhpPreview {
    protected String fInput;
    protected final StyledText fText;
    protected IStructuredDocumentRegion fNodes;
    protected RegionParser fParser;
    protected IPreferenceStore fPreferenceStore;
    protected LineStyleProviderForPhp fStyleProvider = new LineStyleProviderForPhp();
    protected CodeFormatterPreferences codeFormatterPreferences;

    public PhpPreview(CodeFormatterPreferences codeFormatterPreferences, Composite parent) {
        IModelManager mmanager = StructuredModelManager.getModelManager();
        this.fParser = mmanager.createStructuredDocumentFor(ContentTypeIdForPHP.ContentTypeID_PHP).getParser();
        this.codeFormatterPreferences = codeFormatterPreferences;
        this.fText = new StyledText(parent, 33557258);
        GridData data = new GridData(1808);
        this.fText.setLayoutData((Object)data);
        this.fText.setEditable(false);
        this.fText.setFont(JFaceResources.getTextFont());
    }

    public Control getControl() {
        return this.fText;
    }

    public void update() {
        int height = this.fText.getClientArea().height;
        int top0 = this.fText.getTopPixel();
        int totalPixels0 = this.getHeightOfAllLines(this.fText);
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        this.fText.setRedraw(false);
        this.doFormatPreview();
        int totalPixels1 = this.getHeightOfAllLines(this.fText);
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        this.fText.setTopPixel(top1);
        this.fText.setRedraw(true);
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int height = 0;
        int lineCount = styledText.getLineCount();
        int i = 0;
        while (i < lineCount) {
            height += styledText.getLineHeight(styledText.getOffsetAtLine(i));
            ++i;
        }
        return height;
    }

    protected abstract void doFormatPreview();

    protected void applyStyles() {
        if (this.fText == null || this.fText.isDisposed() || this.fInput == null || this.fInput.length() == 0) {
            return;
        }
        this.fStyleProvider.loadColors();
        IStructuredDocumentRegion node = this.fNodes;
        ArrayList holdResults = new ArrayList();
        this.fStyleProvider.prepareTextRegions(node, 0, this.fInput.length(), holdResults);
        for (StyleRange element : holdResults) {
            this.fText.setStyleRange(element);
        }
    }

    public void setText(String s) {
        this.fInput = s;
        this.getParser().reset((Reader)new CharArrayReader(this.fInput.toCharArray()));
        this.fNodes = this.getParser().getDocumentRegions();
        if (this.fText != null) {
            this.fText.setText(s);
        }
        this.applyStyles();
    }

    public RegionParser getParser() {
        return this.fParser;
    }

    public final CodeFormatterPreferences getPreferences() {
        return this.codeFormatterPreferences;
    }

    public final void setPreferences(CodeFormatterPreferences codeFormatterPreferences) {
        this.codeFormatterPreferences = codeFormatterPreferences;
    }
}

