/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.formatter.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.php.formatter.core.CodeFormatterPreferences;
import org.eclipse.php.formatter.ui.FormatterMessages;
import org.eclipse.php.formatter.ui.FormatterUIPlugin;
import org.eclipse.php.formatter.ui.preferences.ModifyDialog;
import org.eclipse.php.formatter.ui.preferences.PhpPreview;
import org.eclipse.php.internal.ui.util.Messages;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class ModifyDialogTabPage {
    protected final Observer fUpdater = new Observer(){

        public void update(Observable o, Object arg) {
            ModifyDialogTabPage.this.updatePreferences();
            ModifyDialogTabPage.this.doUpdatePreview();
            ModifyDialogTabPage.this.notifyValuesModified();
        }
    };
    protected final DefaultFocusManager fDefaultFocusManager;
    protected static String[] FALSE_TRUE = new String[]{"false", "true"};
    protected PixelConverter fPixelConverter;
    protected final CodeFormatterPreferences codeFormatterPreferences;
    private final ModifyDialog fModifyDialog;

    public ModifyDialogTabPage(ModifyDialog modifyDialog, CodeFormatterPreferences preferences) {
        this.codeFormatterPreferences = preferences;
        this.fModifyDialog = modifyDialog;
        this.fDefaultFocusManager = new DefaultFocusManager();
    }

    public Composite createContents(Composite parent) {
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)parent);
        }
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setFont(parent.getFont());
        Composite scrollContainer = new Composite((Composite)sashForm, 0);
        GridData gridData = new GridData(4, 4, true, true);
        scrollContainer.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        scrollContainer.setLayout((Layout)layout);
        ScrolledComposite scroll = new ScrolledComposite(scrollContainer, 768);
        scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        final Composite settingsContainer = new Composite((Composite)scroll, 0);
        settingsContainer.setFont(sashForm.getFont());
        scroll.setContent((Control)settingsContainer);
        settingsContainer.setLayout((Layout)new PageLayout(scroll, 400, 400));
        settingsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite settingsPane = new Composite(settingsContainer, 0);
        settingsPane.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(4, false);
        layout.verticalSpacing = (int)(1.5 * (double)this.fPixelConverter.convertVerticalDLUsToPixels(4));
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        settingsPane.setLayout((Layout)layout);
        this.doCreatePreferences(settingsPane, 4);
        settingsContainer.setSize(settingsContainer.computeSize(-1, -1));
        scroll.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                settingsContainer.setSize(settingsContainer.computeSize(-1, -1));
            }
        });
        Label sashHandle = new Label(scrollContainer, 514);
        gridData = new GridData(131072, 4, false, true);
        sashHandle.setLayoutData((Object)gridData);
        Composite previewPane = new Composite((Composite)sashForm, 0);
        previewPane.setLayout((Layout)this.createGridLayout(4, true));
        previewPane.setFont(sashForm.getFont());
        this.doCreatePreviewPane(previewPane, 4);
        this.initializePage();
        sashForm.setWeights(new int[]{3, 3});
        return sashForm;
    }

    protected abstract void initializePage();

    protected abstract void doCreatePreferences(Composite var1, int var2);

    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        ModifyDialogTabPage.createLabel(numColumns, composite, FormatterMessages.ModifyDialogTabPage_preview_label_text);
        PhpPreview preview = this.doCreatePhpPreview(composite);
        this.fDefaultFocusManager.add(preview.getControl());
        GridData gd = ModifyDialogTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        preview.getControl().setLayoutData((Object)gd);
        return composite;
    }

    protected abstract PhpPreview doCreatePhpPreview(Composite var1);

    public final void makeVisible() {
        this.fDefaultFocusManager.resetFocus();
        this.doUpdatePreview();
    }

    protected abstract void doUpdatePreview();

    protected abstract void updatePreferences();

    protected void notifyValuesModified() {
        this.fModifyDialog.valuesModified();
    }

    public void setInitialFocus() {
        if (this.fDefaultFocusManager.isUsed()) {
            this.fDefaultFocusManager.restoreFocus();
        }
    }

    protected void updateStatus(IStatus status) {
        this.fModifyDialog.updateStatus(status);
    }

    protected GridLayout createGridLayout(int numColumns, boolean margins) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        if (margins) {
            layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        return layout;
    }

    protected static GridData createGridData(int numColumns, int style, int widthHint) {
        GridData gd = new GridData(style);
        gd.horizontalSpan = numColumns;
        gd.widthHint = widthHint;
        return gd;
    }

    protected static Label createLabel(int numColumns, Composite parent, String text) {
        return ModifyDialogTabPage.createLabel(numColumns, parent, text, 768);
    }

    protected static Label createLabel(int numColumns, Composite parent, String text, int gridDataStyle) {
        Label label = new Label(parent, 64);
        label.setFont(parent.getFont());
        label.setText(text);
        label.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, gridDataStyle, -1));
        return label;
    }

    protected Group createGroup(int numColumns, Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 768, -1));
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        group.setLayout((Layout)layout);
        group.setText(text);
        return group;
    }

    protected NumberPreference createNumberPref(Composite composite, int numColumns, String name, int minValue, int maxValue) {
        NumberPreference pref = new NumberPreference(composite, numColumns, name, minValue, maxValue);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected ComboPreference createComboPref(Composite composite, int numColumns, String name, String[] items) {
        ComboPreference pref = new ComboPreference(composite, numColumns, name, items);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected CheckboxPreference createCheckboxPref(Composite composite, int numColumns, String name) {
        CheckboxPreference pref = new CheckboxPreference(composite, numColumns, name);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected StringPreference createStringPref(Composite composite, int numColumns, String name, String key, IInputValidator inputValidator) {
        StringPreference pref = new StringPreference(composite, numColumns, name, inputValidator);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected static String createPreviewHeader(String title) {
        return "/**\n* " + title + "\n*/\n";
    }

    protected final class CheckboxPreference
    extends Preference {
        private final Button fCheckbox;

        public CheckboxPreference(Composite composite, int numColumns, String text) {
            if (text == null) {
                throw new IllegalArgumentException(FormatterMessages.ModifyDialogTabPage_error_msg_values_text_unassigned);
            }
            this.fCheckbox = new Button(composite, 32);
            this.fCheckbox.setText(text);
            this.fCheckbox.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 768, -1));
            this.fCheckbox.setFont(composite.getFont());
            this.fCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CheckboxPreference.this.setChanged();
                }
            });
        }

        public void setIsChecked(boolean isChecked) {
            this.fCheckbox.setSelection(isChecked);
        }

        public boolean isChecked() {
            return this.fCheckbox.getSelection();
        }

        public void setEnabled(boolean isEnabled) {
            this.fCheckbox.setEnabled(isEnabled);
        }

        public boolean isEnabled() {
            return this.fCheckbox.isEnabled();
        }

        public Control getControl() {
            return this.fCheckbox;
        }
    }

    protected final class ComboPreference
    extends Preference {
        private final String[] fItems;
        private final Combo fCombo;

        public ComboPreference(Composite composite, int numColumns, String text, String[] items) {
            if (items == null || text == null) {
                throw new IllegalArgumentException(FormatterMessages.ModifyDialogTabPage_error_msg_values_items_text_unassigned);
            }
            this.fItems = items;
            ModifyDialogTabPage.createLabel(numColumns - 1, composite, text);
            this.fCombo = new Combo(composite, 12);
            this.fCombo.setFont(composite.getFont());
            this.fCombo.setItems(items);
            this.fCombo.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 256, this.fCombo.computeSize((int)-1, (int)-1).x));
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComboPreference.this.setChanged();
                }
            });
        }

        public void setSelectedItem(String item) {
            int index = 0;
            boolean found = false;
            while (index < this.fItems.length) {
                if (this.fItems[index].equals(item)) {
                    found = true;
                    break;
                }
                ++index;
            }
            if (found) {
                this.fCombo.select(index);
            }
        }

        public String getSelectedItem() {
            int index = this.fCombo.getSelectionIndex();
            return this.fItems[index];
        }

        public int getSelectionIndex() {
            return this.fCombo.getSelectionIndex();
        }

        public Control getControl() {
            return this.fCombo;
        }
    }

    protected static final class DefaultFocusManager
    extends FocusAdapter {
        private static final String PREF_LAST_FOCUS_INDEX = "org.eclipse.php.formatter.uiformatter_page.modify_dialog_tab_page.last_focus_index";
        private final IDialogSettings fDialogSettings = FormatterUIPlugin.getDefault().getDialogSettings();
        private final Map fItemMap = new HashMap();
        private final List fItemList = new ArrayList();
        private int fIndex = 0;

        public void focusGained(FocusEvent e) {
            this.fDialogSettings.put(PREF_LAST_FOCUS_INDEX, ((Integer)this.fItemMap.get(e.widget)).intValue());
        }

        public void add(Control control) {
            control.addFocusListener((FocusListener)this);
            this.fItemList.add(this.fIndex, control);
            this.fItemMap.put(control, new Integer(this.fIndex++));
        }

        public void add(Preference preference) {
            Control control = preference.getControl();
            if (control != null) {
                this.add(control);
            }
        }

        public boolean isUsed() {
            return this.fIndex != 0;
        }

        public void restoreFocus() {
            int index = 0;
            try {
                index = this.fDialogSettings.getInt(PREF_LAST_FOCUS_INDEX);
                if (index >= 0 && index <= this.fItemList.size() - 1) {
                    ((Control)this.fItemList.get(index)).setFocus();
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }

        public void resetFocus() {
            this.fDialogSettings.put(PREF_LAST_FOCUS_INDEX, -1);
        }
    }

    protected final class NumberPreference
    extends Preference {
        private final int fMinValue;
        private final int fMaxValue;
        private final Text fNumberText;
        protected int fSelected;
        protected int fOldSelected;

        public NumberPreference(Composite composite, int numColumns, String text, int minValue, int maxValue) {
            ModifyDialogTabPage.createLabel(numColumns - 1, composite, text, 768);
            this.fNumberText = new Text(composite, 133124);
            this.fNumberText.setFont(composite.getFont());
            int length = Integer.toString(maxValue).length() + 3;
            this.fNumberText.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 128, ModifyDialogTabPage.this.fPixelConverter.convertWidthInCharsToPixels(length)));
            this.fMinValue = minValue;
            this.fMaxValue = maxValue;
            this.fNumberText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    NumberPreference.this.focusGained();
                }

                public void focusLost(FocusEvent e) {
                    NumberPreference.this.focusLost();
                }
            });
            this.fNumberText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NumberPreference.this.fieldModified();
                }
            });
        }

        private IStatus createErrorStatus() {
            return new Status(4, "org.eclipse.php.formatter.ui", 0, Messages.format((String)FormatterMessages.ModifyDialogTabPage_NumberPreference_error_invalid_value, (Object[])new String[]{Integer.toString(this.fMinValue), Integer.toString(this.fMaxValue)}), null);
        }

        protected void focusGained() {
            this.fOldSelected = this.fSelected;
            this.fNumberText.setSelection(0, this.fNumberText.getCharCount());
        }

        protected void focusLost() {
            ModifyDialogTabPage.this.updateStatus(null);
            String input = this.fNumberText.getText();
            this.fSelected = !this.validInput(input) ? this.fOldSelected : Integer.parseInt(input);
            if (this.fSelected != this.fOldSelected) {
                this.setChanged();
                this.fNumberText.setText(Integer.toString(this.fSelected));
            }
        }

        protected void fieldModified() {
            int number;
            String trimInput = this.fNumberText.getText().trim();
            boolean valid = this.validInput(trimInput);
            ModifyDialogTabPage.this.updateStatus(valid ? null : this.createErrorStatus());
            if (valid && this.fSelected != (number = Integer.parseInt(trimInput))) {
                this.fSelected = number;
                this.setChanged();
            }
        }

        private boolean validInput(String trimInput) {
            boolean isValid = true;
            try {
                int number = Integer.parseInt(trimInput);
                if (number < this.fMinValue || number > this.fMaxValue) {
                    isValid = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                isValid = false;
            }
            return isValid;
        }

        public void setValue(int value) {
            this.fNumberText.setText(String.valueOf(value));
        }

        public int getValue() {
            return this.fSelected;
        }

        public Control getControl() {
            return this.fNumberText;
        }
    }

    private static class PageLayout
    extends Layout {
        private final ScrolledComposite fContainer;
        private final int fMinimalWidth;
        private final int fMinimalHight;

        private PageLayout(ScrolledComposite container, int minimalWidth, int minimalHight) {
            this.fContainer = container;
            this.fMinimalWidth = minimalWidth;
            this.fMinimalHight = minimalHight;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = this.fMinimalWidth;
            int y = this.fMinimalHight;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            Rectangle area = this.fContainer.getClientArea();
            if (area.width > x) {
                this.fContainer.setExpandHorizontal(true);
            } else {
                this.fContainer.setExpandHorizontal(false);
            }
            if (area.height > y) {
                this.fContainer.setExpandVertical(true);
            } else {
                this.fContainer.setExpandVertical(false);
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }
    }

    protected abstract class Preference
    extends Observable {
        protected Preference() {
        }

        public abstract Control getControl();

        protected void setChanged() {
            super.setChanged();
            this.notifyObservers();
        }
    }

    protected final class StringPreference
    extends Preference {
        private final Label fLabel;
        private IInputValidator fInputValidator;
        private final Text fNumberText;
        protected String fSelected;
        protected String fOldSelected;

        public StringPreference(Composite composite, int numColumns, String text, IInputValidator inputValidator) {
            this.fInputValidator = inputValidator;
            this.fLabel = new Label(composite, 0);
            this.fLabel.setFont(composite.getFont());
            this.fLabel.setText(text);
            this.fLabel.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns - 1, 32, -1));
            this.fNumberText = new Text(composite, 2052);
            this.fNumberText.setFont(composite.getFont());
            this.fNumberText.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 32, ModifyDialogTabPage.this.fPixelConverter.convertWidthInCharsToPixels(30)));
            this.fNumberText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    StringPreference.this.focusGained();
                }

                public void focusLost(FocusEvent e) {
                    StringPreference.this.focusLost();
                }
            });
            this.fNumberText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringPreference.this.fieldModified();
                }
            });
        }

        public void setEnabled(boolean isEnabled) {
            this.fNumberText.setEnabled(isEnabled);
        }

        public boolean isEnabled() {
            return this.fNumberText.isEnabled();
        }

        protected void focusGained() {
            this.fOldSelected = this.fSelected;
            this.fNumberText.setSelection(0, this.fNumberText.getCharCount());
        }

        public void setValue(String value) {
            this.fNumberText.setText(value);
        }

        private IStatus createErrorStatus(String errorText) {
            return new Status(4, "org.eclipse.php.formatter.ui", 0, errorText, null);
        }

        protected void focusLost() {
            ModifyDialogTabPage.this.updateStatus(null);
            String input = this.fNumberText.getText();
            this.fSelected = this.fInputValidator != null && this.fInputValidator.isValid(input) != null ? this.fOldSelected : input;
            if (this.fSelected != this.fOldSelected) {
                this.setChanged();
                this.fNumberText.setText(this.fSelected);
            }
        }

        protected void fieldModified() {
            String errorText;
            String text = this.fNumberText.getText();
            String string = errorText = this.fInputValidator != null ? this.fInputValidator.isValid(text) : null;
            if (errorText == null) {
                ModifyDialogTabPage.this.updateStatus(null);
                if (this.fSelected != text) {
                    this.fSelected = text;
                    this.setChanged();
                }
            } else {
                ModifyDialogTabPage.this.updateStatus(this.createErrorStatus(errorText));
            }
        }

        public String getValue() {
            return this.fSelected;
        }

        public Control getControl() {
            return this.fNumberText;
        }

        protected class Validator {
            protected Validator() {
            }

            boolean isValid(String input) {
                return input != null;
            }
        }
    }
}

