/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import java.util.HashMap;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerConfiguration;

public abstract class AbstractDebuggerConfiguration
implements IDebuggerConfiguration {
    protected Preferences preferences = PHPDebugPlugin.getDefault().getPluginPreferences();
    private HashMap<String, String> attributes = new HashMap();
    private ICommunicationDaemon communicationDaemon;
    private static final String EMPTY_STRING = "";

    public void setAttribute(String id, String value) {
        if (EMPTY_STRING.equals(this.preferences.getDefaultString(id))) {
            this.attributes.put(id, value);
        } else {
            this.preferences.setValue(id, value);
        }
    }

    public String getAttribute(String id) {
        String attribute = this.attributes.get(id);
        if (attribute == null) {
            attribute = this.preferences.getString(id);
        }
        return attribute;
    }

    public void setDebuggerId(String id) {
        this.attributes.put("id", id);
    }

    public String getDebuggerId() {
        return this.getAttribute("id");
    }

    public void setName(String name) {
        this.attributes.put("name", name);
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public abstract void setPort(int var1);

    public abstract int getPort();

    public ICommunicationDaemon getCommunicationDaemon() {
        return this.communicationDaemon;
    }

    public void setCommunicationDaemon(ICommunicationDaemon communicationDaemon) {
        this.communicationDaemon = communicationDaemon;
    }

    public void save() {
        PHPDebugPlugin.getDefault().savePluginPreferences();
    }

    public abstract void applyDefaults();
}

