/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import com.google.inject.Inject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.clustermode.ClusterMode;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.AttrList;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.AttributeType;
import org.eclipse.gef.dot.internal.language.dot.DotGraph;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.dot.NodeStmt;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.outputmode.OutputMode;
import org.eclipse.gef.dot.internal.language.pagedir.Pagedir;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.services.DotGrammarAccess;
import org.eclipse.gef.dot.internal.language.splines.Splines;
import org.eclipse.gef.dot.internal.language.style.ClusterStyle;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.contentassist.AbstractDotProposalProvider;
import org.eclipse.gef.dot.internal.ui.language.contentassist.DotColorProposalProvider;
import org.eclipse.gef.dot.internal.ui.language.contentassist.DotProposalProviderDelegator;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class DotProposalProvider
extends AbstractDotProposalProvider {
    @Inject
    private DotGrammarAccess dotGrammarAccess;
    @Inject
    private IImageHelper imageHelper;
    private static Map<DotAttributes.Context, List<String>> dotAttributeNames;
    private String[] booleanAttributeValuesProposals = new String[]{"true", "false"};

    public DotProposalProvider() {
        if (dotAttributeNames == null) {
            dotAttributeNames = this.getDotAttributeNames();
        }
    }

    protected ICompletionProposal createCompletionProposal(String proposal, StyledString displayString, Image image, int priority, String prefix, ContentAssistContext context) {
        ICompletionProposal completionProposal;
        EObject currentModel = context.getCurrentModel();
        DotGraph dotGraph = (DotGraph)EcoreUtil2.getContainerOfType((EObject)currentModel, DotGraph.class);
        if (dotGraph != null) {
            GraphType graphType = dotGraph.getType();
            if (EdgeOp.get((String)proposal) != null) {
                if (graphType == GraphType.DIGRAPH && proposal.equals(EdgeOp.UNDIRECTED.toString())) {
                    return null;
                }
                if (graphType == GraphType.GRAPH && proposal.equals(EdgeOp.DIRECTED.toString())) {
                    return null;
                }
                String format = "%s: Edge";
                displayString = DotEditorUtils.style(format, proposal);
            }
        }
        if (prefix.equals("=") && proposal.equals("=")) {
            return null;
        }
        if (prefix.equals("[") && proposal.equals("[")) {
            return null;
        }
        if ("subgraph".equals(proposal)) {
            String format = "%s: Subgraph";
            displayString = DotEditorUtils.style(format, proposal);
        }
        if ((completionProposal = super.createCompletionProposal(proposal, displayString, image, priority, prefix, context)) instanceof ConfigurableCompletionProposal) {
            String text;
            ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
            if (dotGraph != null && AttributeType.get((String)proposal) != null && !context.getLastCompleteNode().getText().equals("strict")) {
                String format = "%s[]: Attributes";
                StyledString newDisplayString = DotEditorUtils.style(format, displayString);
                configurableCompletionProposal.setDisplayString(newDisplayString);
                configurableCompletionProposal.setReplacementString(String.valueOf(configurableCompletionProposal.getReplacementString()) + "[]");
                configurableCompletionProposal.setCursorPosition(configurableCompletionProposal.getCursorPosition() + 1);
            }
            if (currentModel instanceof Attribute && (text = context.getCurrentNode().getText()).trim().startsWith("\"")) {
                configurableCompletionProposal.setReplacementOffset(configurableCompletionProposal.getReplacementOffset() + 1);
                configurableCompletionProposal.setReplacementLength(configurableCompletionProposal.getReplacementLength() - 1);
            }
        }
        return completionProposal;
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        if (context.getCurrentModel() instanceof Attribute && prefix.startsWith("\"")) {
            return super.isValidProposal(proposal, prefix.substring(1), context);
        }
        return super.isValidProposal(proposal, prefix, context);
    }

    @Override
    public void completePort_Compass_pt(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Keyword k : EcoreUtil2.getAllContentsOfType((EObject)this.dotGrammarAccess.getCOMPASS_PTRule().getAlternatives(), Keyword.class)) {
            acceptor.accept(this.createCompletionProposal(k.getValue(), context));
        }
        super.completePort_Compass_pt(model, assignment, context, acceptor);
    }

    @Override
    public void completeAttribute_Name(EObject model, Assignment assignment, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        super.completeAttribute_Name(model, assignment, contentAssistContext, acceptor);
        if (model instanceof AttrList) {
            DotAttributes.Context attributeContext = DotAttributes.getContext((EObject)model);
            this.proposeAttributeNames(attributeContext, contentAssistContext, acceptor);
        } else if (model instanceof DotGraph || model instanceof NodeStmt) {
            this.proposeAttributeNames(DotAttributes.Context.GRAPH, contentAssistContext, acceptor);
        }
    }

    @Override
    public void completeAttribute_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block175: {
            block172: {
                block180: {
                    Attribute attribute;
                    block178: {
                        block176: {
                            block173: {
                                if (!(model instanceof Attribute)) break block172;
                                attribute = (Attribute)model;
                                if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.EDGE) break block173;
                                switch (attribute.getName().toValue()) {
                                    case "arrowhead": 
                                    case "arrowtail": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotArrowType", context, acceptor);
                                        break;
                                    }
                                    case "color": {
                                        this.proposeColorListAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "edgetooltip": 
                                    case "tooltip": 
                                    case "labeltooltip": 
                                    case "headtooltip": 
                                    case "tailtooltip": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotEscString", context, acceptor);
                                        break;
                                    }
                                    case "fillcolor": {
                                        this.proposeColorAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "fontcolor": 
                                    case "labelfontcolor": {
                                        this.proposeColorAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "colorscheme": {
                                        this.proposeColorSchemeAttributeValues(context, acceptor);
                                        break;
                                    }
                                    case "dir": {
                                        this.proposeAttributeValues(DirType.values(), context, acceptor);
                                        break;
                                    }
                                    case "tail_lp": 
                                    case "lp": 
                                    case "xlp": 
                                    case "head_lp": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                        break;
                                    }
                                    case "xlabel": 
                                    case "headlabel": 
                                    case "taillabel": 
                                    case "label": {
                                        this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                        break;
                                    }
                                    case "headport": 
                                    case "tailport": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPortPos", context, acceptor);
                                        break;
                                    }
                                    case "pos": {
                                        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotSplineType", context, acceptor);
                                        break;
                                    }
                                    case "style": {
                                        this.proposeAttributeValues(EdgeStyle.VALUES, context, acceptor);
                                        break;
                                    }
                                    default: {
                                        super.completeAttribute_Value(model, assignment, context, acceptor);
                                        break;
                                    }
                                }
                                break block175;
                            }
                            if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.GRAPH) break block176;
                            switch (attribute.getName().toValue()) {
                                case "bgcolor": {
                                    this.proposeColorListAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "fontcolor": {
                                    this.proposeColorAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "clusterrank": {
                                    this.proposeAttributeValues(ClusterMode.values(), context, acceptor);
                                    break;
                                }
                                case "colorscheme": {
                                    this.proposeColorSchemeAttributeValues(context, acceptor);
                                    break;
                                }
                                case "forcelabels": {
                                    this.proposeAttributeValues(this.booleanAttributeValuesProposals, context, acceptor);
                                    break;
                                }
                                case "label": {
                                    this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                    break;
                                }
                                case "layout": {
                                    this.proposeAttributeValues(Layout.values(), context, acceptor);
                                    break;
                                }
                                case "lp": {
                                    this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                    break;
                                }
                                case "outputorder": {
                                    this.proposeAttributeValues(OutputMode.values(), context, acceptor);
                                    break;
                                }
                                case "pagedir": {
                                    this.proposeAttributeValues(Pagedir.values(), context, acceptor);
                                    break;
                                }
                                case "rankdir": {
                                    this.proposeAttributeValues(Rankdir.values(), context, acceptor);
                                    break;
                                }
                                case "splines": {
                                    this.proposeAttributeValues(Splines.values(), context, acceptor);
                                    break;
                                }
                                default: {
                                    super.completeAttribute_Value(model, assignment, context, acceptor);
                                    break;
                                }
                            }
                            break block175;
                        }
                        if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.NODE) break block178;
                        switch (attribute.getName().toValue()) {
                            case "color": {
                                this.proposeColorAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "fillcolor": {
                                this.proposeColorListAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "fontcolor": {
                                this.proposeColorAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "colorscheme": {
                                this.proposeColorSchemeAttributeValues(context, acceptor);
                                break;
                            }
                            case "fixedsize": {
                                this.proposeAttributeValues(this.booleanAttributeValuesProposals, context, acceptor);
                                break;
                            }
                            case "xlabel": 
                            case "label": {
                                this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                                break;
                            }
                            case "pos": 
                            case "xlp": {
                                this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotPoint", context, acceptor);
                                break;
                            }
                            case "shape": {
                                this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotShape", context, acceptor);
                                break;
                            }
                            case "style": {
                                this.proposeAttributeValues(NodeStyle.VALUES, context, acceptor);
                                break;
                            }
                            case "tooltip": {
                                this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotEscString", context, acceptor);
                            }
                        }
                        break block175;
                    }
                    if (DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.CLUSTER && DotAttributes.getContext((EObject)attribute) != DotAttributes.Context.SUBGRAPH) break block180;
                    switch (attribute.getName().toValue()) {
                        case "bgcolor": {
                            this.proposeColorListAttributeValues(attribute, context, acceptor);
                            break;
                        }
                        case "color": {
                            this.proposeColorAttributeValues(attribute, context, acceptor);
                            break;
                        }
                        case "colorscheme": {
                            this.proposeColorSchemeAttributeValues(context, acceptor);
                            break;
                        }
                        case "fillcolor": {
                            this.proposeColorListAttributeValues(attribute, context, acceptor);
                            break;
                        }
                        case "fontcolor": {
                            this.proposeColorAttributeValues(attribute, context, acceptor);
                            break;
                        }
                        case "label": {
                            this.proposeHtmlLabelAttributeValues(attribute, context, acceptor);
                            break;
                        }
                        case "style": {
                            this.proposeAttributeValues(ClusterStyle.VALUES, context, acceptor);
                            break;
                        }
                        case "tooltip": {
                            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotEscString", context, acceptor);
                        }
                    }
                    break block175;
                }
                super.completeAttribute_Value(model, assignment, context, acceptor);
                break block175;
            }
            super.completeAttribute_Value(model, assignment, context, acceptor);
        }
    }

    private void proposeAttributeNames(DotAttributes.Context attributeContext, ContentAssistContext contentAssistContext, ICompletionProposalAcceptor acceptor) {
        Image attributeImage = this.imageHelper.getImage("attribute.png");
        String format = "%s: Attribute";
        for (String attributeName : dotAttributeNames.get(attributeContext)) {
            StyledString displayString = DotEditorUtils.style(format, attributeName);
            ICompletionProposal completionProposal = this.createCompletionProposal(attributeName, displayString, attributeImage, contentAssistContext);
            if (completionProposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
                configurableCompletionProposal.setReplacementString(String.valueOf(configurableCompletionProposal.getReplacementString()) + "=");
                configurableCompletionProposal.setCursorPosition(configurableCompletionProposal.getCursorPosition() + 1);
            }
            acceptor.accept(completionProposal);
        }
    }

    private void proposeAttributeValues(String subgrammarName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String text = context.getPrefix();
        if (text.startsWith("\"")) {
            text = ID.fromString((String)text, (ID.Type)ID.Type.QUOTED_STRING).toValue();
            context = context.copy().setPrefix(text).toContext();
        }
        if (text.startsWith("<")) {
            text = text.substring(1);
            context = context.copy().setPrefix(text).toContext();
        }
        List<ConfigurableCompletionProposal> configurableCompletionProposals = new DotProposalProviderDelegator(subgrammarName).computeConfigurableCompletionProposals(text, text.length());
        for (ConfigurableCompletionProposal configurableCompletionProposal : configurableCompletionProposals) {
            configurableCompletionProposal.setReplacementOffset(context.getOffset() - configurableCompletionProposal.getReplaceContextLength());
            acceptor.accept((ICompletionProposal)configurableCompletionProposal);
        }
    }

    private void proposeAttributeValues(Object[] values, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeAttributeValues(Arrays.asList(values), context, acceptor);
    }

    private void proposeAttributeValues(List<?> values, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        for (Object value : values) {
            String proposedValue = ID.fromValue((String)value.toString()).toString();
            acceptor.accept(this.createCompletionProposal(proposedValue, context));
        }
    }

    private void proposeColorAttributeValues(Attribute attribute, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        DotColorProposalProvider.globalColorScheme = DotAstHelper.getColorSchemeAttributeValue((Attribute)attribute);
        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotColor", context, acceptor);
        DotColorProposalProvider.globalColorScheme = null;
    }

    private void proposeColorListAttributeValues(Attribute attribute, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        DotColorProposalProvider.globalColorScheme = DotAstHelper.getColorSchemeAttributeValue((Attribute)attribute);
        this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotColorList", context, acceptor);
        DotColorProposalProvider.globalColorScheme = null;
    }

    private void proposeColorSchemeAttributeValues(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.proposeAttributeValues(DotColors.getColorSchemes(), context, acceptor);
    }

    private void proposeHtmlLabelAttributeValues(Attribute attribute, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (attribute.getValue() != null && attribute.getValue().getType() == ID.Type.HTML_STRING) {
            this.proposeAttributeValues("org.eclipse.gef.dot.internal.language.DotHtmlLabel", context, acceptor);
        }
    }

    private Map<DotAttributes.Context, List<String>> getDotAttributeNames() {
        Field[] declaredFields;
        ArrayList<String> edgeAttributeNames = new ArrayList<String>();
        ArrayList<String> graphAttributeNames = new ArrayList<String>();
        ArrayList<String> nodeAttributeNames = new ArrayList<String>();
        Field[] fieldArray = declaredFields = DotAttributes.class.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && field.getType().equals(String.class)) {
                String fieldName = field.getName();
                String dotClassifier = fieldName.substring(fieldName.lastIndexOf("_") + 1);
                if (!fieldName.startsWith("_")) {
                    String dotAttributeName = null;
                    try {
                        dotAttributeName = (String)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    if (dotAttributeName != null) {
                        if (dotClassifier.contains("E")) {
                            edgeAttributeNames.add(dotAttributeName);
                        }
                        if (dotClassifier.contains("G")) {
                            graphAttributeNames.add(dotAttributeName);
                        }
                        if (dotClassifier.contains("N")) {
                            nodeAttributeNames.add(dotAttributeName);
                        }
                    }
                }
            }
            ++n2;
        }
        HashMap<DotAttributes.Context, List<String>> dotAttributeNames = new HashMap<DotAttributes.Context, List<String>>();
        dotAttributeNames.put(DotAttributes.Context.EDGE, edgeAttributeNames);
        dotAttributeNames.put(DotAttributes.Context.GRAPH, graphAttributeNames);
        dotAttributeNames.put(DotAttributes.Context.NODE, nodeAttributeNames);
        return dotAttributeNames;
    }
}

