/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.renaming;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.dot.internal.language.DotAstHelper;
import org.eclipse.gef.dot.internal.language.dot.NodeId;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.DefaultRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringException;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.ITextRegion;

public class DotRenameStrategy
extends DefaultRenameStrategy {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    private EObject targetElement;

    public boolean initialize(EObject targetElement, IRenameElementContext context) {
        if (super.initialize(targetElement, context)) {
            this.targetElement = targetElement;
            return true;
        }
        return false;
    }

    protected EAttribute getNameAttribute(EObject targetElement) {
        for (EAttribute attribute : targetElement.eClass().getEAttributes()) {
            if (!attribute.getName().equals("name")) continue;
            return attribute;
        }
        return null;
    }

    protected String getNameAsText(String nameAsValue, String nameRuleName) {
        return nameAsValue;
    }

    protected EObject setName(URI targetElementURI, String newName, ResourceSet resourceSet) {
        EObject targetElement = resourceSet.getEObject(targetElementURI, false);
        if (targetElement == null) {
            throw new RefactoringException("Target element not loaded.");
        }
        targetElement.eSet((EStructuralFeature)this.getNameAttribute(), (Object)ID.fromString((String)newName));
        return targetElement;
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
        super.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
        URI resourceURI = this.getTargetElementOriginalURI().trimFragment();
        if (this.targetElement instanceof NodeId) {
            NodeId targetNodeId = (NodeId)this.targetElement;
            List dependentNodeIds = DotAstHelper.getAllNodeIds((NodeId)targetNodeId);
            for (NodeId dependentNodeId : dependentNodeIds) {
                ITextRegion dependentNodeIdTextRegion = this.locationInFileProvider.getFullTextRegion((EObject)dependentNodeId);
                ReplaceEdit referenceEdit = new ReplaceEdit(dependentNodeIdTextRegion.getOffset(), dependentNodeIdTextRegion.getLength(), newName);
                updateAcceptor.accept(resourceURI, (TextEdit)referenceEdit);
            }
        }
    }
}

