/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.zest.examples.graph;

import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javafx.application.Application;
import javafx.scene.shape.Polygon;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef.zest.examples.AbstractZestExample;
import org.eclipse.gef.zest.examples.graph.ZestGraphExampleModule;

public class ZestGraphExample
extends AbstractZestExample {
    private static Graph buildAC(String id) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(Arrays.asList(ZestGraphExample.n("A", id, "Alpha"), ZestGraphExample.n("B", id, "Beta"), ZestGraphExample.n("C", id, "Gamma")));
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.addAll(Arrays.asList(ZestGraphExample.e((Node)nodes.get(0), (Node)nodes.get(1)), ZestGraphExample.e((Node)nodes.get(1), (Node)nodes.get(2)), ZestGraphExample.e((Node)nodes.get(2), (Node)nodes.get(0))));
        HashMap<String, SpringLayoutAlgorithm> attrs = new HashMap<String, SpringLayoutAlgorithm>();
        attrs.put("graph-layout-algorithm", new SpringLayoutAlgorithm());
        return new Graph(attrs, nodes, edges);
    }

    private static Graph buildAE(String id) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(Arrays.asList(ZestGraphExample.n("A", id, "Alpha"), ZestGraphExample.n("B", id, "Beta"), ZestGraphExample.n("C", id, "Gamma"), ZestGraphExample.n("D", id, "Delta"), ZestGraphExample.n("E", id, "Epsilon")));
        ((Node)nodes.get(4)).setNestedGraph(ZestGraphExample.buildAC("c"));
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.addAll(Arrays.asList(ZestGraphExample.e((Node)nodes.get(0), (Node)nodes.get(1)), ZestGraphExample.e((Node)nodes.get(1), (Node)nodes.get(2)), ZestGraphExample.e((Node)nodes.get(2), (Node)nodes.get(3)), ZestGraphExample.e((Node)nodes.get(3), (Node)nodes.get(4)), ZestGraphExample.e((Node)nodes.get(4), (Node)nodes.get(0))));
        HashMap<String, SpringLayoutAlgorithm> attrs = new HashMap<String, SpringLayoutAlgorithm>();
        attrs.put("graph-layout-algorithm", new SpringLayoutAlgorithm());
        return new Graph(attrs, nodes, edges);
    }

    public static Graph createDefaultGraph() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(Arrays.asList(ZestGraphExample.n("0", "", "zero"), ZestGraphExample.n("1", "", "one"), ZestGraphExample.n("2", "", "two"), ZestGraphExample.n("3", "", "three"), ZestGraphExample.n("4", "", "four"), ZestGraphExample.n("5", "", "five"), ZestGraphExample.n("6", "", "six"), ZestGraphExample.n("7", "", "seven"), ZestGraphExample.n("8", "", "eight"), ZestGraphExample.n("9", "", "nine")));
        ((Node)nodes.get(0)).setNestedGraph(ZestGraphExample.buildAC("a"));
        ((Node)nodes.get(5)).setNestedGraph(ZestGraphExample.buildAE("b"));
        ArrayList<Edge> edges = new ArrayList<Edge>();
        edges.addAll(Arrays.asList(ZestGraphExample.e((Node)nodes.get(0), (Node)nodes.get(9)), ZestGraphExample.e((Node)nodes.get(1), (Node)nodes.get(8)), ZestGraphExample.e((Node)nodes.get(2), (Node)nodes.get(7)), ZestGraphExample.e((Node)nodes.get(3), (Node)nodes.get(6)), ZestGraphExample.e((Node)nodes.get(4), (Node)nodes.get(5)), ZestGraphExample.e((Node)nodes.get(0), (Node)nodes.get(4)), ZestGraphExample.e((Node)nodes.get(1), (Node)nodes.get(6)), ZestGraphExample.e((Node)nodes.get(2), (Node)nodes.get(8)), ZestGraphExample.e((Node)nodes.get(3), (Node)nodes.get(5)), ZestGraphExample.e((Node)nodes.get(4), (Node)nodes.get(7)), ZestGraphExample.e((Node)nodes.get(5), (Node)nodes.get(1))));
        HashMap<String, SpringLayoutAlgorithm> attrs = new HashMap<String, SpringLayoutAlgorithm>();
        attrs.put("graph-layout-algorithm", new SpringLayoutAlgorithm());
        return new Graph(attrs, nodes, edges);
    }

    private static Edge e(Node n, Node m) {
        return ZestGraphExample.e((Node)n, (Node)m, (Object[])new Object[]{"edge-target-decoration", new Polygon(new double[]{0.0, 0.0, 10.0, 3.0, 10.0, -3.0}), "edge-target-decoration-css-style", "-fx-fill: white;"});
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static Node n(String label, String idPrefix, String tooltip) {
        return ZestGraphExample.n((Object[])new Object[]{"element-label", label, "element-css-id", String.valueOf(idPrefix) + label, "node-tooltip", tooltip});
    }

    public ZestGraphExample() {
        super("GEF Zest Graph Example");
    }

    protected Graph createGraph() {
        return ZestGraphExample.createDefaultGraph();
    }

    protected Module createModule() {
        return new ZestGraphExampleModule();
    }
}

