/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.tools;

import org.eclipse.draw2d.Cursors;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.examples.text.GraphicalTextViewer;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.edit.TextEditPart;
import org.eclipse.gef.examples.text.requests.CaretRequest;
import org.eclipse.gef.examples.text.requests.SearchResult;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.graphics.Cursor;

public class SelectionRangeDragTracker
extends SimpleDragTracker {
    private static final int STATE_START = 64;
    private static final int STATE_SWIPE = 128;
    private TextLocation beginDrag;
    private TextLocation endDrag;
    private boolean isWordSelection;
    private final TextEditPart textSource;

    public SelectionRangeDragTracker(TextEditPart part) {
        this.textSource = part;
    }

    protected Cursor calculateCursor() {
        return Cursors.IBEAM;
    }

    private void doNormalSwipe() {
        SearchResult result = this.getCurrentTextLocation();
        this.endDrag = result.location;
        if (this.endDrag != null) {
            TextEditPart end = this.endDrag.part;
            TextEditPart begin = this.beginDrag.part;
            boolean inverted = false;
            if (end == begin) {
                inverted = this.endDrag.offset < this.beginDrag.offset;
            } else {
                EditPart ancestor = ToolUtilities.findCommonAncestor((EditPart)end, (EditPart)begin);
                while (end.getParent() != ancestor) {
                    end = end.getParent();
                }
                while (begin.getParent() != ancestor) {
                    begin = begin.getParent();
                }
                inverted = ancestor.getChildren().indexOf(end) < ancestor.getChildren().indexOf(begin);
            }
            GraphicalTextViewer viewer = (GraphicalTextViewer)this.getCurrentViewer();
            if (!inverted) {
                viewer.setSelectionRange(new SelectionRange(this.beginDrag, this.endDrag, true, result.trailing));
            } else {
                viewer.setSelectionRange(new SelectionRange(this.endDrag, this.beginDrag, false, result.trailing));
            }
        }
    }

    private void doWordSelect() {
        SearchResult result = new SearchResult();
        CaretRequest locationRequest = new CaretRequest();
        locationRequest.setType(CaretRequest.LOCATION);
        locationRequest.setLocation(this.getLocation());
        locationRequest.isForward = true;
        this.getSource().getTextLocation(locationRequest, result);
        TextLocation exact = result.location;
        CaretRequest nextWord = new CaretRequest();
        result = new SearchResult();
        nextWord.setType(CaretRequest.WORD_BOUNDARY);
        nextWord.isForward = true;
        nextWord.where = exact;
        this.getSource().getTextLocation(nextWord, result);
        TextLocation wordEnd = result.location;
        boolean isAfter = result.trailing;
        result = new SearchResult();
        nextWord.where = wordEnd;
        nextWord.isForward = false;
        this.getSource().getTextLocation(nextWord, result);
        TextLocation wordBegin = result.location;
        if (wordBegin != null && wordEnd != null) {
            ((GraphicalTextViewer)this.getCurrentViewer()).setSelectionRange(new SelectionRange(wordBegin, wordEnd, true, isAfter));
        }
    }

    private void doWordSwipe() {
    }

    protected String getCommandName() {
        return "Drop Text Request";
    }

    private SearchResult getCurrentTextLocation() {
        TextEditPart textPart;
        SearchResult result = new SearchResult();
        EditPart part = this.getCurrentViewer().findObjectAt(this.getLocation());
        if (part instanceof TextEditPart && (textPart = (TextEditPart)part).acceptsCaret()) {
            CaretRequest request = new CaretRequest();
            request.setType(CaretRequest.LOCATION);
            request.setLocation(this.getLocation());
            textPart.getTextLocation(request, result);
        }
        return result;
    }

    private TextEditPart getSource() {
        return this.textSource;
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            SearchResult result = this.getCurrentTextLocation();
            this.beginDrag = result.location;
            ((GraphicalTextViewer)this.getCurrentViewer()).setSelectionRange(new SelectionRange(this.beginDrag, this.beginDrag, true, result.trailing));
            return this.stateTransition(1, 64);
        }
        return super.handleButtonDown(button);
    }

    protected boolean handleDoubleClick(int button) {
        if (button == 1) {
            this.doWordSelect();
            this.isWordSelection = true;
            return true;
        }
        return super.handleDoubleClick(button);
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(128)) {
            if (this.isWordSelection) {
                this.doWordSwipe();
            } else {
                this.doNormalSwipe();
            }
        }
        return super.handleDragInProgress();
    }

    protected boolean handleDragStarted() {
        return this.stateTransition(64, 128);
    }
}

