/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.graph.BreakCycles;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.GraphVisitor;
import org.eclipse.draw2d.graph.HorizontalPlacement;
import org.eclipse.draw2d.graph.InitialRankSolver;
import org.eclipse.draw2d.graph.LocalOptimizer;
import org.eclipse.draw2d.graph.MinCross;
import org.eclipse.draw2d.graph.PopulateRanks;
import org.eclipse.draw2d.graph.RankAssigmentSolver;
import org.eclipse.draw2d.graph.RouteEdges;
import org.eclipse.draw2d.graph.TightSpanningTreeSolver;
import org.eclipse.draw2d.graph.TransposeMetrics;
import org.eclipse.draw2d.graph.VerticalPlacement;

public class DirectedGraphLayout {
    List steps = new ArrayList();

    public DirectedGraphLayout() {
        this.init();
    }

    void init() {
        this.steps.add(new TransposeMetrics());
        this.steps.add(new BreakCycles());
        this.steps.add(new RouteEdges());
        this.steps.add(new InitialRankSolver());
        this.steps.add(new TightSpanningTreeSolver());
        this.steps.add(new RankAssigmentSolver());
        this.steps.add(new PopulateRanks());
        this.steps.add(new VerticalPlacement());
        this.steps.add(new MinCross());
        this.steps.add(new LocalOptimizer());
        this.steps.add(new HorizontalPlacement());
    }

    public void visit(DirectedGraph graph) {
        GraphVisitor visitor;
        if (graph.nodes.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.steps.size()) {
            visitor = (GraphVisitor)this.steps.get(i);
            visitor.visit(graph);
            ++i;
        }
        i = this.steps.size() - 1;
        while (i >= 0) {
            visitor = (GraphVisitor)this.steps.get(i);
            visitor.revisit(graph);
            --i;
        }
    }
}

