/*******************************************************************************
 * Copyright (c) 2014, 2016 itemis AG and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Matthias Wienand (itemis AG) - initial API & implementation
 *
 *******************************************************************************/
package org.eclipse.gef4.zest.fx.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.fx.policies.IFXOnClickPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.policies.AbstractInteractionPolicy;
import org.eclipse.gef4.zest.fx.operations.NavigateOperation;
import org.eclipse.gef4.zest.fx.parts.NodePart;

import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

/**
 * The {@link OpenNestedGraphOnDoubleClickPolicy} is an {@link IFXOnClickPolicy}
 * that can be installed on {@link NodePart}s (see {@link #getHost()}).
 * It opens the {@link Graph} that is nested inside of its
 * {@link NodePart} when the {@link NodePart} is double clicked.
 *
 * @author mwienand
 *
 */
public class OpenNestedGraphOnDoubleClickPolicy extends AbstractInteractionPolicy<Node> implements IFXOnClickPolicy {

	@Override
	public void click(MouseEvent event) {
		if (event.getClickCount() == 2) {
			// double click, so open nested graph, if it exists
			final Graph nestedGraph = getHost().getContent().getNestedGraph();
			if (nestedGraph != null) {
				FXViewer viewer = (FXViewer) getHost().getRoot().getViewer();
				try {
					viewer.getDomain().execute(new NavigateOperation(viewer, nestedGraph, true));
				} catch (ExecutionException e) {
					throw new RuntimeException(e);
				}
			}
		}
	}

	@Override
	public NodePart getHost() {
		return (NodePart) super.getHost();
	}

}
