/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal.parser.style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EdgeStyle implements Enumerator
{
    BOLD(0, "bold", "bold"),
    DASHED(1, "dashed", "dashed"),
    DOTTED(2, "dotted", "dotted"),
    INVIS(3, "invis", "invis"),
    SOLID(4, "solid", "solid"),
    TAPERED(5, "tapered", "tapered");

    public static final int BOLD_VALUE = 0;
    public static final int DASHED_VALUE = 1;
    public static final int DOTTED_VALUE = 2;
    public static final int INVIS_VALUE = 3;
    public static final int SOLID_VALUE = 4;
    public static final int TAPERED_VALUE = 5;
    private static final EdgeStyle[] VALUES_ARRAY;
    public static final List<EdgeStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EdgeStyle[]{BOLD, DASHED, DOTTED, INVIS, SOLID, TAPERED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EdgeStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeStyle get(int value) {
        switch (value) {
            case 0: {
                return BOLD;
            }
            case 1: {
                return DASHED;
            }
            case 2: {
                return DOTTED;
            }
            case 3: {
                return INVIS;
            }
            case 4: {
                return SOLID;
            }
            case 5: {
                return TAPERED;
            }
        }
        return null;
    }

    private EdgeStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

