/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal.parser.dot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EdgeOp implements Enumerator
{
    DIRECTED(0, "directed", "->"),
    UNDIRECTED(1, "undirected", "--");

    public static final int DIRECTED_VALUE = 0;
    public static final int UNDIRECTED_VALUE = 1;
    private static final EdgeOp[] VALUES_ARRAY;
    public static final List<EdgeOp> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EdgeOp[]{DIRECTED, UNDIRECTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EdgeOp get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeOp result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeOp getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EdgeOp result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EdgeOp get(int value) {
        switch (value) {
            case 0: {
                return DIRECTED;
            }
            case 1: {
                return UNDIRECTED;
            }
        }
        return null;
    }

    private EdgeOp(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

