/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.util.Pair;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.behaviors.ContentBehavior;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.behaviors.GraphLayoutBehavior;

public class GraphPart
extends AbstractFXContentPart<Group> {
    private ListChangeListener<Object> graphChildrenObserver = new ListChangeListener<Object>(){

        public void onChanged(ListChangeListener.Change<? extends Object> c) {
            ((ContentBehavior)GraphPart.this.getAdapter((TypeToken)new TypeToken<ContentBehavior<Node>>(){})).synchronizeContentChildren(GraphPart.this.doGetContentChildren());
            GraphLayoutBehavior layoutBehavior = (GraphLayoutBehavior)((Object)GraphPart.this.getAdapter(GraphLayoutBehavior.class));
            if (layoutBehavior != null) {
                layoutBehavior.applyLayout(true);
            }
        }
    };

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Group)this.getVisual()).getChildren().add(index, (Object)((Node)child.getVisual()));
    }

    protected Group createVisual() {
        Group visual = new Group();
        visual.setAutoSizeChildren(false);
        return visual;
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().getNodes().addListener(this.graphChildrenObserver);
        this.getContent().getEdges().addListener(this.graphChildrenObserver);
    }

    protected void doDeactivate() {
        this.getContent().getNodes().removeListener(this.graphChildrenObserver);
        this.getContent().getEdges().removeListener(this.graphChildrenObserver);
        super.doDeactivate();
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        ArrayList children = new ArrayList();
        ObservableList nodes = this.getContent().getNodes();
        ArrayList<org.eclipse.gef4.graph.Node> visibleNodes = new ArrayList<org.eclipse.gef4.graph.Node>();
        for (org.eclipse.gef4.graph.Node n : nodes) {
            if (Boolean.TRUE.equals(ZestProperties.getInvisible(n))) continue;
            visibleNodes.add(n);
        }
        children.addAll(visibleNodes);
        for (org.eclipse.gef4.graph.Node n : visibleNodes) {
            if (ZestProperties.getExternalLabel(n) == null) continue;
            children.add(new Pair((Object)n, (Object)"element-external-label"));
        }
        ObservableList edges = this.getContent().getEdges();
        ArrayList<Edge> visibleEdges = new ArrayList<Edge>();
        for (Edge e : edges) {
            if (Boolean.TRUE.equals(ZestProperties.getInvisible(e)) || e.getSource() == null || Boolean.TRUE.equals(ZestProperties.getInvisible(e.getSource())) || e.getTarget() == null || Boolean.TRUE.equals(ZestProperties.getInvisible(e.getTarget()))) continue;
            visibleEdges.add(e);
        }
        children.addAll(visibleEdges);
        for (Edge e : visibleEdges) {
            if (ZestProperties.getLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"label"));
            }
            if (ZestProperties.getExternalLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"element-external-label"));
            }
            if (ZestProperties.getSourceLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"edge-source-label"));
            }
            if (ZestProperties.getTargetLabel(e) == null) continue;
            children.add(new Pair((Object)e, (Object)"edge-target-label"));
        }
        return children;
    }

    public void doRefreshVisual(Group visual) {
    }

    public Graph getContent() {
        return (Graph)super.getContent();
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Group)this.getVisual()).getChildren().remove(child.getVisual());
    }
}

