/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.operations;

import java.util.Collections;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.fx.operations.FXChangeViewportOperation;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.operations.ChangeContentsOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.gef4.zest.fx.models.NavigationModel;

public class NavigateOperation
extends ForwardUndoCompositeOperation {
    private ChangeContentsOperation changeContentsOperation;
    private FXChangeViewportOperation changeViewportOperation;
    private NavigationModel navigationModel;
    private FXViewer viewer;
    private Graph sourceGraph;
    private UpdateViewportStateOperation updateViewportStateOperation;

    public NavigateOperation(FXViewer viewer) {
        super("Navigate Graph");
        this.viewer = viewer;
        this.sourceGraph = (Graph)((ContentModel)viewer.getAdapter(ContentModel.class)).getContents().get(0);
        this.navigationModel = (NavigationModel)viewer.getAdapter(NavigationModel.class);
        this.changeContentsOperation = new ChangeContentsOperation((IViewer)viewer, Collections.singletonList(this.sourceGraph));
        this.changeViewportOperation = new FXChangeViewportOperation(viewer.getCanvas());
        this.updateViewportStateOperation = new UpdateViewportStateOperation(this.navigationModel.getViewportState(this.sourceGraph));
        this.add((IUndoableOperation)this.changeViewportOperation);
        this.add((IUndoableOperation)this.changeContentsOperation);
        this.add((IUndoableOperation)this.updateViewportStateOperation);
    }

    public NavigateOperation(FXViewer viewer, Graph targetGraph, boolean isNestedGraph) {
        this(viewer);
        this.setFinalState(targetGraph, isNestedGraph);
    }

    public FXChangeViewportOperation getChangeViewportOperation() {
        return this.changeViewportOperation;
    }

    public void setFinalState(Graph targetGraph, boolean isNestedGraph) {
        InfiniteCanvas canvas = this.viewer.getCanvas();
        if (isNestedGraph) {
            NavigationModel.ViewportState sourceGraphFinalViewportState = new NavigationModel.ViewportState(canvas.getHorizontalScrollOffset(), canvas.getVerticalScrollOffset(), canvas.getWidth(), canvas.getHeight(), FX2Geometry.toAffineTransform((Transform)canvas.getContentTransform()));
            this.updateViewportStateOperation.setFinalViewportState(sourceGraphFinalViewportState);
            this.changeViewportOperation.setInitialWidth(sourceGraphFinalViewportState.getWidth());
            this.changeViewportOperation.setInitialHeight(sourceGraphFinalViewportState.getHeight());
            this.changeViewportOperation.setInitialHorizontalScrollOffset(sourceGraphFinalViewportState.getTranslateX());
            this.changeViewportOperation.setInitialVerticalScrollOffset(sourceGraphFinalViewportState.getTranslateY());
            this.changeViewportOperation.setInitialContentTransform(sourceGraphFinalViewportState.getContentsTransform());
        } else {
            this.updateViewportStateOperation.setFinalViewportState(null);
        }
        NavigationModel.ViewportState newViewportState = this.navigationModel.getViewportState(targetGraph);
        if (newViewportState == null || isNestedGraph) {
            newViewportState = new NavigationModel.ViewportState(0.0, 0.0, canvas.getWidth(), canvas.getHeight(), new AffineTransform());
        }
        this.changeViewportOperation.setNewWidth(newViewportState.getWidth());
        this.changeViewportOperation.setNewHeight(newViewportState.getHeight());
        this.changeViewportOperation.setNewHorizontalScrollOffset(newViewportState.getTranslateX());
        this.changeViewportOperation.setNewVerticalScrollOffset(newViewportState.getTranslateY());
        this.changeViewportOperation.setNewContentTransform(newViewportState.getContentsTransform());
        this.changeContentsOperation.setNewContents(Collections.singletonList(targetGraph));
    }

    private final class UpdateViewportStateOperation
    extends AbstractOperation
    implements ITransactionalOperation {
        private NavigationModel.ViewportState initialViewportState;
        private NavigationModel.ViewportState finalViewportState;

        public UpdateViewportStateOperation(NavigationModel.ViewportState initialViewportState) {
            super("Update Viewport State");
            this.initialViewportState = initialViewportState == null ? null : initialViewportState.getCopy();
            this.finalViewportState = initialViewportState;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.finalViewportState != null) {
                NavigateOperation.this.navigationModel.setViewportState(NavigateOperation.this.sourceGraph, this.finalViewportState);
            } else {
                NavigateOperation.this.navigationModel.removeViewportState(NavigateOperation.this.sourceGraph);
            }
            return Status.OK_STATUS;
        }

        public boolean isContentRelevant() {
            return false;
        }

        public boolean isNoOp() {
            return this.initialViewportState == null ? this.finalViewportState == null : this.initialViewportState.equals(this.finalViewportState);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public void setFinalViewportState(NavigationModel.ViewportState finalViewportState) {
            this.finalViewportState = finalViewportState;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.initialViewportState != null) {
                NavigateOperation.this.navigationModel.setViewportState(NavigateOperation.this.sourceGraph, this.initialViewportState);
            } else {
                NavigateOperation.this.navigationModel.removeViewportState(NavigateOperation.this.sourceGraph);
            }
            return Status.OK_STATUS;
        }
    }
}

