/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.models;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.property.ReadOnlySetWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import org.eclipse.gef4.common.collections.CollectionUtils;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class HidingModel {
    public static final String HIDDEN_PROPERTY = "hidden";
    private ReadOnlySetWrapper<Node> hiddenProperty = new ReadOnlySetWrapper((Object)this, "hidden", FXCollections.observableSet(new HashSet()));

    public Set<NodePart> getHiddenNeighborParts(NodePart nodePart) {
        Set<Node> hiddenNeighbors = this.getHiddenNeighbors(nodePart.getContent());
        Set<NodePart> hiddenNeighborParts = Collections.newSetFromMap(new IdentityHashMap());
        Map contentPartMap = nodePart.getRoot().getViewer().getContentPartMap();
        for (Node neighbor : hiddenNeighbors) {
            hiddenNeighborParts.add((NodePart)((Object)contentPartMap.get(neighbor)));
        }
        return hiddenNeighborParts;
    }

    public Set<Node> getHiddenNeighbors(Node node) {
        Set neighbors = node.getLocalNeighbors();
        Set<Node> hiddenNeighbors = Collections.newSetFromMap(new IdentityHashMap());
        for (Node neighbor : neighbors) {
            if (!this.isHidden(neighbor)) continue;
            hiddenNeighbors.add(neighbor);
        }
        return hiddenNeighbors;
    }

    public Set<Node> getHiddenNodesUnmodifiable() {
        return CollectionUtils.unmodifiableObservableSet((ObservableSet)this.hiddenProperty.get());
    }

    public boolean hasHiddenNeighbors(NodePart nodePart) {
        return this.hasHiddenNeighbors(nodePart.getContent());
    }

    public boolean hasHiddenNeighbors(Node node) {
        return this.getHiddenNeighbors(node).size() > 0;
    }

    public ReadOnlySetProperty<Node> hiddenProperty() {
        return this.hiddenProperty.getReadOnlyProperty();
    }

    public void hide(NodePart nodePart) {
        this.hide(nodePart.getContent());
    }

    public void hide(Node node) {
        this.hiddenProperty.add((Object)node);
    }

    public boolean isHidden(NodePart nodePart) {
        return this.isHidden(nodePart.getContent());
    }

    public boolean isHidden(Node node) {
        return this.hiddenProperty.contains((Object)node);
    }

    public void show(NodePart nodePart) {
        this.show(nodePart.getContent());
    }

    public void show(Node node) {
        this.hiddenProperty.remove((Object)node);
    }
}

