/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout;

import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;

public class LayoutProperties {
    public static final String BOUNDS_PROPERTY = "layout_bounds";
    public static final String LOCATION_PROPERTY = "layout_location";
    public static final String SIZE_PROPERTY = "layout_size";
    public static final String MOVABLE_PROPERTY = "layout_movable";
    public static final Boolean DEFAULT_MOVABLE = true;
    public static final String RESIZABLE_PROPERTY = "layout_resizable";
    public static final Boolean DEFAULT_RESIZABLE = true;
    public static final String ASPECT_RATIO_PROPERTY = "layout_aspect-ratio";
    public static final Double DEFAULT_ASPECT_RATIO = 0.0;
    public static final String WEIGHT_PROPERTY = "layout_weight";
    public static final Double DEFAULT_WEIGHT = 0.0;
    public static final int DIRECTION_TOP_DOWN = 1;
    public static final int DIRECTION_BOTTOM_UP = 2;
    public static final int DIRECTION_LEFT_RIGHT = 3;
    public static final int DIRECTION_RIGHT_LEFT = 4;
    public static final String DIRECTION_PROPERTY = "layout_direction";
    public static final Integer DEFAULT_DIRECTION = 1;

    public static Rectangle getBounds(Graph graph) {
        return (Rectangle)graph.getAttributes().get((Object)BOUNDS_PROPERTY);
    }

    public static void setBounds(Graph graph, Rectangle bounds) {
        graph.getAttributes().put((Object)BOUNDS_PROPERTY, (Object)bounds);
    }

    public static Point getLocation(Node node) {
        return (Point)node.getAttributes().get((Object)LOCATION_PROPERTY);
    }

    public static Dimension getSize(Node node) {
        return (Dimension)node.getAttributes().get((Object)SIZE_PROPERTY);
    }

    public static Double getPreferredAspectRatio(Node node) {
        Object ar = node.getAttributes().get((Object)ASPECT_RATIO_PROPERTY);
        if (ar instanceof Double) {
            return (Double)ar;
        }
        return DEFAULT_ASPECT_RATIO;
    }

    public static Boolean isResizable(Node node) {
        Object resizable = node.getAttributes().get((Object)RESIZABLE_PROPERTY);
        if (resizable instanceof Boolean) {
            return (Boolean)resizable;
        }
        return DEFAULT_RESIZABLE;
    }

    public static Boolean isMovable(Node node) {
        Object movable = node.getAttributes().get((Object)MOVABLE_PROPERTY);
        if (movable instanceof Boolean) {
            return (Boolean)movable;
        }
        return DEFAULT_MOVABLE;
    }

    public static void setLocation(Node node, Point location) {
        node.getAttributes().put((Object)LOCATION_PROPERTY, (Object)location);
    }

    public static void setSize(Node node, Dimension size) {
        node.getAttributes().put((Object)SIZE_PROPERTY, (Object)size);
    }

    public static void setResizable(Node node, boolean resizable) {
        node.getAttributes().put((Object)RESIZABLE_PROPERTY, (Object)resizable);
    }

    public static Double getWeight(Edge edge) {
        Object weight = edge.getAttributes().get((Object)WEIGHT_PROPERTY);
        if (weight instanceof Double) {
            return (Double)weight;
        }
        return DEFAULT_WEIGHT;
    }

    public static void setWeight(Edge edge, double weight) {
        edge.getAttributes().put((Object)WEIGHT_PROPERTY, (Object)weight);
    }
}

