/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.Arrays;
import org.eclipse.gef4.geometry.internal.utils.PointListUtils;
import org.eclipse.gef4.geometry.planar.AbstractPointListBasedGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;

public class Polyline
extends AbstractPointListBasedGeometry<Polyline>
implements ICurve {
    private static final long serialVersionUID = 1L;

    public Polyline(double ... coordinates) {
        super(coordinates);
    }

    public Polyline(Line[] segmentsArray) {
        super(PointListUtils.toPointsArray(segmentsArray, false));
    }

    public Polyline(Point ... points) {
        super(points);
    }

    public boolean contains(double x, double y) {
        return this.contains(new Point(x, y));
    }

    @Override
    public boolean contains(Point p) {
        int i = 0;
        while (i + 1 < this.points.length) {
            Point p1 = this.points[i];
            Point p2 = this.points[i + 1];
            if (new Line(p1, p2).contains(p)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Polyline) {
            Polyline p = (Polyline)o;
            return this.equals(p.getPoints());
        }
        return false;
    }

    public boolean equals(Point ... points) {
        if (points.length != this.points.length) {
            return false;
        }
        return Arrays.equals(this.points, points) || Arrays.equals(this.points, Point.getReverseCopy(points));
    }

    @Override
    public Polyline getCopy() {
        return new Polyline(this.getPoints());
    }

    public Line[] getCurves() {
        return PointListUtils.toSegmentsArray(this.points, false);
    }

    @Override
    public Point[] getIntersections(ICurve c) {
        return CurveUtils.getIntersections((ICurve)this, c);
    }

    public double getLength() {
        double length = 0.0;
        Line[] lineArray = this.getCurves();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            length += line.getLength();
            ++n2;
        }
        return length;
    }

    @Override
    public ICurve[] getOverlaps(ICurve c) {
        return CurveUtils.getOverlaps(this, c);
    }

    @Override
    public Point getP1() {
        return this.points[0].getCopy();
    }

    @Override
    public Point getP2() {
        return this.points[this.points.length - 1].getCopy();
    }

    @Override
    public Point getProjection(Point reference) {
        double minDistance = 0.0;
        Point minProjection = null;
        Line[] lineArray = this.toBezier();
        int n = lineArray.length;
        int n2 = 0;
        while (n2 < n) {
            Line bc = lineArray[n2];
            Point projection = ((BezierCurve)bc).getProjection(reference);
            double distance = projection.getDistance(reference);
            if (minProjection == null || distance < minDistance) {
                minProjection = projection;
                minDistance = distance;
            }
            ++n2;
        }
        return minProjection;
    }

    @Override
    public Polyline getTransformed(AffineTransform t) {
        return new Polyline(t.getTransformed(this.points));
    }

    @Override
    public double getX1() {
        return this.getP1().x;
    }

    @Override
    public double getX2() {
        return this.getP2().x;
    }

    @Override
    public double getY1() {
        return this.getP1().y;
    }

    @Override
    public double getY2() {
        return this.getP2().y;
    }

    @Override
    public boolean intersects(ICurve c) {
        return CurveUtils.intersect(c, this);
    }

    @Override
    public boolean overlaps(ICurve c) {
        return CurveUtils.overlap(c, this);
    }

    public Line[] toBezier() {
        return PointListUtils.toSegmentsArray(this.points, false);
    }

    @Override
    public Path toPath() {
        Path path = new Path();
        if (this.points.length > 0) {
            path.moveTo(this.points[0].x, this.points[0].y);
            int i = 1;
            while (i < this.points.length) {
                path.lineTo(this.points[i].x, this.points[i].y);
                ++i;
            }
        }
        return path;
    }

    public PolyBezier toPolyBezier() {
        BezierCurve[] segments = PointListUtils.toSegmentsArray(this.points, false);
        return new PolyBezier(segments);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Polyline: ");
        if (this.points.length > 0) {
            int i = 0;
            while (i < this.points.length) {
                stringBuffer.append("(" + this.points[i].x + ", " + this.points[i].y + ")");
                if (i < this.points.length - 1) {
                    stringBuffer.append(" -> ");
                }
                ++i;
            }
        } else {
            stringBuffer.append("<no points>");
        }
        return stringBuffer.toString();
    }
}

