/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef4.geometry.planar.AbstractRectangleBasedGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.CubicCurve;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.CurvedPolygon;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.ShapeUtils;

public class Ellipse
extends AbstractRectangleBasedGeometry<Ellipse, PolyBezier>
implements IShape {
    private static final long serialVersionUID = 1L;

    public Ellipse(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    public Ellipse(Rectangle r) {
        this(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(IGeometry g) {
        return ShapeUtils.contains((IShape)this, g);
    }

    public boolean contains(Line l) {
        return this.contains(l.getP1()) && this.contains(l.getP2());
    }

    @Override
    public boolean contains(Point p) {
        double normalizedX = p.x - (this.x + this.width / 2.0);
        double normalizedY = p.y - (this.y + this.height / 2.0);
        if (PrecisionUtils.smallerEqual(normalizedX * normalizedX / (this.width * this.width * 0.25) + normalizedY * normalizedY / (this.height * this.height * 0.25), 1.0)) {
            return true;
        }
        CubicCurve[] cubicCurveArray = this.getOutlineSegments();
        int n = cubicCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubicCurve seg = cubicCurveArray[n2];
            if (seg.contains(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean equals(double x, double y, double width, double height) {
        return PrecisionUtils.equal(this.x, x) && PrecisionUtils.equal(this.y, y) && PrecisionUtils.equal(this.width, width) && PrecisionUtils.equal(this.height, height);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Ellipse) {
            Ellipse e = (Ellipse)o;
            return this.equals(e.getX(), e.getY(), e.getWidth(), e.getHeight());
        }
        return false;
    }

    @Override
    public Ellipse getCopy() {
        return new Ellipse(this.x, this.y, this.width, this.height);
    }

    public Point[] getIntersections(Ellipse e2) {
        if (this.equals(e2)) {
            return new Point[0];
        }
        HashSet<Point> intersections = new HashSet<Point>();
        CubicCurve[] cubicCurveArray = this.getOutlineSegments();
        int n = cubicCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubicCurve seg = cubicCurveArray[n2];
            intersections.addAll(Arrays.asList(e2.getIntersections(seg)));
            ++n2;
        }
        return intersections.toArray(new Point[0]);
    }

    public Point[] getIntersections(ICurve c) {
        if (c instanceof Line) {
            return this.getIntersections((Line)c);
        }
        return CurveUtils.getIntersections(c, this);
    }

    public Point[] getIntersections(Line line) {
        ArrayList<Point> intersections = new ArrayList<Point>(2);
        double a = this.width / 2.0;
        double b = this.height / 2.0;
        double aSq = this.width * this.width * 0.25;
        double bSq = this.height * this.height * 0.25;
        double xOffset = this.x + a;
        double yOffset = this.y + b;
        double x1 = line.getX1() - xOffset;
        double y1 = line.getY1() - yOffset;
        double x2 = line.getX2() - xOffset;
        double y2 = line.getY2() - yOffset;
        double dy = y2 - y1;
        double dx = x2 - x1;
        if (PrecisionUtils.equal(dx, 0.0, 2)) {
            if (PrecisionUtils.smallerEqual(-a, x1) && PrecisionUtils.smallerEqual(x1, a)) {
                double y;
                double rad = bSq * (1.0 - x1 * x1 / aSq);
                double d = y = rad < 0.0 ? 0.0 : Math.sqrt(rad);
                if (y == 0.0) {
                    if (this.isInBetween(0.0, y1, y2)) {
                        intersections.add(new Point(x1, 0.0));
                    }
                } else {
                    if (this.isInBetween(y, y1, y2)) {
                        intersections.add(new Point(x1, y));
                    }
                    if (this.isInBetween(-y, y1, y2)) {
                        intersections.add(new Point(x1, -y));
                    }
                }
            }
        } else {
            double m = dy / dx;
            double n = y1 - m * x1;
            double q1 = 2.0 * m * aSq * n;
            double q2 = bSq + aSq * m * m;
            double p = q1 / q2;
            double q0 = aSq * (n * n - bSq);
            double q = q0 / q2;
            double d = p * p / 4.0 - q;
            if (PrecisionUtils.equal(d, 0.0, 2)) {
                double px = -p / 2.0;
                double py = px * m + n;
                intersections.add(new Point(px, py));
            } else if (d > 0.0) {
                double sqrt = d < 0.0 ? 0.0 : Math.sqrt(d);
                double px = -p / 2.0 + sqrt;
                double py = px * m + n;
                intersections.add(new Point(px, py));
                px = -p / 2.0 - sqrt;
                py = px * m + n;
                intersections.add(new Point(px, py));
            }
        }
        Iterator i = intersections.iterator();
        while (i.hasNext()) {
            Point p = (Point)i.next();
            p.translate(xOffset, yOffset);
            if (line.contains(p)) continue;
            i.remove();
        }
        return intersections.toArray(new Point[0]);
    }

    @Override
    public ICurve getOutline() {
        return ShapeUtils.getOutline(this);
    }

    public CubicCurve[] getOutlineSegments() {
        return new CubicCurve[]{ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromDeg(0.0), Angle.fromDeg(90.0)), ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromDeg(90.0), Angle.fromDeg(180.0)), ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromDeg(180.0), Angle.fromDeg(270.0)), ShapeUtils.computeEllipticalArcApproximation(this.x, this.y, this.width, this.height, Angle.fromDeg(270.0), Angle.fromDeg(360.0))};
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle) {
        return new PolyBezier(this.getOutlineSegments()).rotateCCW(angle);
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle, double cx, double cy) {
        return new PolyBezier(this.getOutlineSegments()).rotateCCW(angle, cx, cy);
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle, Point center) {
        return new PolyBezier(this.getOutlineSegments()).rotateCCW(angle, center);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle) {
        return new PolyBezier(this.getOutlineSegments()).rotateCW(angle);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle, double cx, double cy) {
        return new PolyBezier(this.getOutlineSegments()).rotateCW(angle, cx, cy);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle, Point center) {
        return new PolyBezier(this.getOutlineSegments()).rotateCW(angle, center);
    }

    @Override
    public CurvedPolygon getTransformed(AffineTransform t) {
        return new CurvedPolygon(this.getOutlineSegments()).getTransformed(t);
    }

    private boolean isInBetween(double a, double lower, double upper) {
        if (upper < lower) {
            double tmp = upper;
            upper = lower;
            lower = tmp;
        }
        return PrecisionUtils.greaterEqual(a, lower) && PrecisionUtils.smallerEqual(a, upper);
    }

    @Override
    public Path toPath() {
        return CurveUtils.toPath(this.getOutlineSegments());
    }

    public String toString() {
        return "Ellipse (" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }
}

