/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.internal.utils;

public class PrecisionUtils {
    private static final int DEFAULT_SCALE = 6;

    public static final double calculateFraction(int shift) {
        return 1.0 / Math.pow(10.0, 6 + shift);
    }

    public static final boolean equal(double d1, double d2) {
        return PrecisionUtils.equal(d1, d2, 0);
    }

    public static final boolean equal(double d1, double d2, int shift) {
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Cannot compare undefined values d1 = " + d1 + ", d2 = " + d2);
        }
        return Math.abs(d1 - d2) <= PrecisionUtils.calculateFraction(shift);
    }

    public static final boolean greater(double d1, double d2) {
        return PrecisionUtils.greater(d1, d2, 0);
    }

    public static final boolean greater(double d1, double d2, int shift) {
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Cannot compare undefined values d1 = " + d1 + ", d2 = " + d2);
        }
        return d1 + PrecisionUtils.calculateFraction(shift) > d2;
    }

    public static final boolean greaterEqual(double d1, double d2) {
        return PrecisionUtils.greaterEqual(d1, d2, 0);
    }

    public static final boolean greaterEqual(double d1, double d2, int shift) {
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Cannot compare undefined values d1 = " + d1 + ", d2 = " + d2);
        }
        return d1 + PrecisionUtils.calculateFraction(shift) >= d2;
    }

    public static final boolean smaller(double d1, double d2) {
        return PrecisionUtils.smaller(d1, d2, 0);
    }

    public static final boolean smaller(double d1, double d2, int shift) {
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Cannot compare undefined values d1 = " + d1 + ", d2 = " + d2);
        }
        return d1 < d2 + PrecisionUtils.calculateFraction(shift);
    }

    public static final boolean smallerEqual(double d1, double d2) {
        return PrecisionUtils.smallerEqual(d1, d2, 0);
    }

    public static final boolean smallerEqual(double d1, double d2, int shift) {
        if (Double.isNaN(d1) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Cannot compare undefined values d1 = " + d1 + ", d2 = " + d2);
        }
        return d1 <= d2 + PrecisionUtils.calculateFraction(shift);
    }

    private PrecisionUtils() {
    }
}

