/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.convert.awt;

import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.RoundedRectangle;

public class AWT2Geometry {
    public static AffineTransform toAffineTransform(java.awt.geom.AffineTransform t) {
        double[] matrix = new double[6];
        t.getMatrix(matrix);
        return new AffineTransform(matrix);
    }

    public static final Line toLine(Line2D l) {
        return new Line(AWT2Geometry.toPoint(l.getP1()), AWT2Geometry.toPoint(l.getP2()));
    }

    public static Path toPath(Path2D p) {
        PathIterator iterator = p.getPathIterator(null);
        Path path = new Path(p.getWindingRule() == 1 ? 1 : 0);
        while (!iterator.isDone()) {
            double[] segment = new double[6];
            int type = iterator.currentSegment(segment);
            switch (type) {
                case 0: {
                    path.moveTo(segment[0], segment[1]);
                    break;
                }
                case 1: {
                    path.lineTo(segment[0], segment[1]);
                    break;
                }
                case 2: {
                    path.quadTo(segment[0], segment[1], segment[2], segment[3]);
                    break;
                }
                case 3: {
                    path.cubicTo(segment[0], segment[1], segment[2], segment[3], segment[4], segment[5]);
                    break;
                }
                case 4: {
                    path.close();
                }
            }
            iterator.next();
        }
        return path;
    }

    public static final Point toPoint(Point2D p) {
        return new Point(p.getX(), p.getY());
    }

    public static Point[] toPoints(Point2D[] pts) {
        Point[] points = new Point[pts.length];
        int i = 0;
        while (i < pts.length) {
            points[i] = AWT2Geometry.toPoint(pts[i]);
            ++i;
        }
        return points;
    }

    public static final Rectangle toRectangle(Rectangle2D r) {
        return new Rectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public static RoundedRectangle toRoundedRectangle(RoundRectangle2D r) {
        return new RoundedRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight(), r.getArcWidth() * 2.0, r.getArcHeight() * 2.0);
    }

    private AWT2Geometry() {
    }
}

