/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.ZoomEvent;
import org.eclipse.gef4.fx.gestures.AbstractPinchSpreadGesture;
import org.eclipse.gef4.mvc.fx.policies.IFXOnPinchSpreadPolicy;
import org.eclipse.gef4.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXPinchSpreadTool
extends AbstractTool<Node> {
    public static final Class<IFXOnPinchSpreadPolicy> ON_PINCH_SPREAD_POLICY_KEY = IFXOnPinchSpreadPolicy.class;
    @Inject
    private ITargetPolicyResolver targetPolicyResolver;
    private final Map<Scene, AbstractPinchSpreadGesture> gestures = new HashMap<Scene, AbstractPinchSpreadGesture>();
    private final Map<IViewer<Node>, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer<Node>, ChangeListener<Boolean>>();

    public List<? extends IFXOnPinchSpreadPolicy> getActivePolicies(IViewer<Node> viewer) {
        return super.getActivePolicies(viewer);
    }

    protected void registerListeners() {
        super.registerListeners();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue == null || !newValue.booleanValue()) {
                        for (IFXOnPinchSpreadPolicy iFXOnPinchSpreadPolicy : FXPinchSpreadTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                            iFXOnPinchSpreadPolicy.zoomAborted();
                        }
                        FXPinchSpreadTool.this.clearActivePolicies(viewer);
                        FXPinchSpreadTool.this.getDomain().closeExecutionTransaction((ITool)FXPinchSpreadTool.this);
                    }
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put((IViewer<Node>)viewer, viewerFocusChangeListener);
            Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
            if (this.gestures.containsKey(scene)) continue;
            AbstractPinchSpreadGesture gesture = new AbstractPinchSpreadGesture(){

                protected void zoom(ZoomEvent e) {
                    for (IFXOnPinchSpreadPolicy iFXOnPinchSpreadPolicy : FXPinchSpreadTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnPinchSpreadPolicy.zoom(e);
                    }
                }

                protected void zoomFinished(ZoomEvent e) {
                    for (IFXOnPinchSpreadPolicy iFXOnPinchSpreadPolicy : FXPinchSpreadTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnPinchSpreadPolicy.zoomFinished(e);
                    }
                    FXPinchSpreadTool.this.clearActivePolicies(viewer);
                    FXPinchSpreadTool.this.getDomain().closeExecutionTransaction((ITool)FXPinchSpreadTool.this);
                }

                protected void zoomStarted(ZoomEvent e) {
                    if (!FXPinchSpreadTool.this.getDomain().isExecutionTransactionOpen((ITool)FXPinchSpreadTool.this)) {
                        FXPinchSpreadTool.this.getDomain().openExecutionTransaction((ITool)FXPinchSpreadTool.this);
                    }
                    EventTarget eventTarget = e.getTarget();
                    FXPinchSpreadTool.this.setActivePolicies(viewer, FXPinchSpreadTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXPinchSpreadTool.this, eventTarget instanceof Node ? (Node)eventTarget : null, ON_PINCH_SPREAD_POLICY_KEY));
                    for (IFXOnPinchSpreadPolicy iFXOnPinchSpreadPolicy : FXPinchSpreadTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnPinchSpreadPolicy.zoomStarted(e);
                    }
                }
            };
            gesture.setScene(((FXViewer)viewer).getScene());
            this.gestures.put(scene, gesture);
        }
    }

    protected void unregisterListeners() {
        for (Scene scene : new ArrayList<Scene>(this.gestures.keySet())) {
            this.gestures.remove(scene).setScene(null);
        }
        for (IViewer iViewer : new ArrayList<IViewer<Node>>(this.viewerFocusChangeListeners.keySet())) {
            iViewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(iViewer));
        }
        super.unregisterListeners();
    }
}

