/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.IPolicy;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class DefaultTargetPolicyResolver
implements ITargetPolicyResolver {
    private static final AdapterKeyComparator ADAPTER_KEY_COMPARATOR = new AdapterKeyComparator(true);

    @Override
    public <T extends IPolicy<Node>> List<? extends T> getTargetPolicies(ITool<Node> contextTool, Node target, Class<T> policyClass) {
        IViewer<Node> viewer = FXPartUtils.retrieveViewer((IDomain<Node>)contextTool.getDomain(), target);
        if (viewer == null) {
            return Collections.emptyList();
        }
        return this.getTargetPolicies(contextTool, target, viewer, policyClass);
    }

    @Override
    public <T extends IPolicy<Node>> List<? extends T> getTargetPolicies(ITool<Node> contextTool, Node target, IViewer<Node> viewer, Class<T> policyClass) {
        IVisualPart targetPart;
        ArrayList<IPolicy> outerTargetPolicies = new ArrayList<IPolicy>();
        Collection tools = viewer.getDomain().getAdapters((TypeToken)new TypeToken<ITool<Node>>(){}).values();
        for (ITool tool : tools) {
            if (tool == contextTool) continue;
            for (IPolicy policy : tool.getActivePolicies(viewer)) {
                if (!policy.getClass().isAssignableFrom(policyClass)) continue;
                try {
                    outerTargetPolicies.add(policy);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        if (!outerTargetPolicies.isEmpty()) {
            return outerTargetPolicies;
        }
        IVisualPart part = targetPart = FXPartUtils.retrieveVisualPart(viewer, target);
        ArrayList<IPolicy> policies = new ArrayList<IPolicy>();
        while (part != null) {
            Map partPolicies = part.getAdapters(policyClass);
            ArrayList descendinglySortedKeys = new ArrayList(partPolicies.keySet());
            Collections.sort(descendinglySortedKeys, ADAPTER_KEY_COMPARATOR);
            for (AdapterKey key : descendinglySortedKeys) {
                policies.add((IPolicy)partPolicies.get(key));
            }
            part = part.getParent();
        }
        Collections.reverse(policies);
        return policies;
    }

    private static final class AdapterKeyComparator
    implements Comparator<AdapterKey<?>> {
        private boolean descending;

        public AdapterKeyComparator(boolean descending) {
            this.descending = descending;
        }

        @Override
        public int compare(AdapterKey<?> lhs, AdapterKey<?> rhs) {
            int cmp = lhs.getRole().compareTo(rhs.getRole());
            return this.descending ? -cmp : cmp;
        }
    }
}

