/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.StaticAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.operations.FXBendConnectionOperation;
import org.eclipse.gef4.mvc.fx.policies.FXBendConnectionPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.operations.BendContentOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IBendableContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXTransformConnectionPolicy
extends FXTransformPolicy {
    private List<IBendableContentPart.BendPoint> initialBendPoints;
    private List<Point> initialConnectionPositions;
    private List<Integer> movableConnectionIndices;
    private List<Integer> movableOperationIndices;

    public ITransactionalOperation commit() {
        ITransactionalOperation commit = super.commit();
        this.initialConnectionPositions = null;
        this.initialBendPoints = null;
        this.movableConnectionIndices = null;
        this.movableOperationIndices = null;
        return commit;
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new FXBendConnectionOperation((Connection)this.getHost().getVisual());
    }

    protected ITransactionalOperation createTransformContentOperation() {
        return new BendContentOperation((IBendableContentPart)this.getHost(), this.initialBendPoints, FXBendConnectionPolicy.getCurrentBendPoints(this.getHost()));
    }

    protected FXBendConnectionOperation getBendConnectionOperation() {
        return (FXBendConnectionOperation)this.getOperation();
    }

    public IVisualPart<Node, Connection> getHost() {
        return super.getHost();
    }

    protected List<Integer> getIndicesOfUnconnectedAnchors() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        Connection connection = this.getBendConnectionOperation().getConnection();
        IConnectionRouter router = connection.getRouter();
        ObservableList anchorsUnmodifiable = connection.getAnchorsUnmodifiable();
        int i = 0;
        while (i < anchorsUnmodifiable.size()) {
            IAnchor a = (IAnchor)anchorsUnmodifiable.get(i);
            if (!connection.isConnected(i) && !router.wasInserted(a)) {
                indices.add(i);
            }
            ++i;
        }
        return indices;
    }

    public void init() {
        super.init();
        AffineTransform inverse = null;
        try {
            inverse = this.getInitialTransform().invert();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        this.movableConnectionIndices = this.getIndicesOfUnconnectedAnchors();
        this.movableOperationIndices = new ArrayList<Integer>();
        Connection connection = this.getBendConnectionOperation().getConnection();
        List<IAnchor> newAnchors = this.getBendConnectionOperation().getNewAnchors();
        int i = 0;
        while (i < newAnchors.size()) {
            IAnchor anchor = newAnchors.get(i);
            if (anchor == null || anchor.getAnchorage() == null || anchor.getAnchorage() == connection) {
                this.movableOperationIndices.add(i);
            }
            ++i;
        }
        this.initialConnectionPositions = new ArrayList<Point>();
        for (Point p : connection.getPointsUnmodifiable()) {
            this.initialConnectionPositions.add(inverse.getTransformed(p));
        }
        this.initialBendPoints = FXBendConnectionPolicy.getCurrentBendPoints(this.getHost());
    }

    protected boolean isContentTransformable() {
        return this.getHost() instanceof IBendableContentPart;
    }

    @Override
    protected void updateTransformOperation(AffineTransform newTransform) {
        int i = 0;
        while (i < this.movableConnectionIndices.size()) {
            int connectionIndex = this.movableConnectionIndices.get(i);
            int operationIndex = this.movableOperationIndices.get(i);
            Point pTx = newTransform.getTransformed(this.initialConnectionPositions.get(connectionIndex));
            this.getBendConnectionOperation().getNewAnchors().set(operationIndex, (IAnchor)new StaticAnchor((Node)this.getHost().getVisual(), new Point(pTx.x, pTx.y)));
            ++i;
        }
    }
}

