/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.CursorSupport;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public class FXRotateSelectedOnHandleDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private ImageCursor rotateCursor;
    private boolean invalidGesture = false;
    private Point initialPointerLocationInScene;
    private Point pivotInScene;
    private Map<IContentPart<Node, ? extends Node>, Integer> rotationIndices = new HashMap<IContentPart<Node, ? extends Node>, Integer>();
    private List<IContentPart<Node, ? extends Node>> targetParts;

    protected Angle computeRotationAngleCW(MouseEvent e, IVisualPart<Node, ? extends Node> part) {
        Vector vStart = new Vector(this.pivotInScene, this.initialPointerLocationInScene);
        Vector vEnd = new Vector(this.pivotInScene, new Point(e.getSceneX(), e.getSceneY()));
        Angle angle = vStart.getAngleCW(vEnd);
        return angle;
    }

    protected ImageCursor createRotateCursor() {
        return new ImageCursor(new Image(FXRotateSelectedOnHandleDragPolicy.class.getResource("/rotate_obj.gif").toExternalForm()));
    }

    protected List<IContentPart<Node, ? extends Node>> determineTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable();
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, (IVisualPart<Node, ? extends Node>)iVisualPart);
        }
    }

    @Override
    public void dragAborted() {
        if (this.invalidGesture) {
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            FXTransformPolicy transformPolicy = this.getTransformPolicy((IVisualPart<Node, ? extends Node>)iVisualPart);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(iVisualPart);
            this.rollback((AbstractTransactionPolicy)transformPolicy);
        }
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    protected Cursor getRotateCursor() {
        if (this.rotateCursor == null) {
            this.rotateCursor = this.createRotateCursor();
        }
        return this.rotateCursor;
    }

    protected List<IContentPart<Node, ? extends Node>> getTargetParts() {
        return this.targetParts;
    }

    protected FXTransformPolicy getTransformPolicy(IVisualPart<Node, ? extends Node> part) {
        return (FXTransformPolicy)((Object)part.getAdapter(FXTransformPolicy.class));
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    protected boolean isRotate(MouseEvent event) {
        return event.isControlDown();
    }

    @Override
    public void press(MouseEvent e) {
        Rectangle bounds;
        boolean bl = this.invalidGesture = !this.isRotate(e);
        if (this.invalidGesture) {
            return;
        }
        this.initialPointerLocationInScene = new Point(e.getSceneX(), e.getSceneY());
        this.targetParts = this.determineTargetParts();
        if (this.targetParts == null) {
            this.targetParts = Collections.emptyList();
        }
        if ((bounds = FXPartUtils.getUnionedVisualBoundsInScene(this.targetParts)) == null) {
            throw new IllegalStateException("Cannot determine visual bounds (null).");
        }
        this.pivotInScene = bounds.getCenter();
        this.rotationIndices.clear();
        for (IContentPart<Node, ? extends Node> part : this.getTargetParts()) {
            FXTransformPolicy transformPolicy = this.getTransformPolicy((IVisualPart<Node, ? extends Node>)part);
            if (transformPolicy == null) continue;
            this.storeAndDisableRefreshVisuals((IVisualPart)part);
            this.init((AbstractTransactionPolicy)transformPolicy);
            Point pivotInLocal = FX2Geometry.toPoint((Point2D)((Node)this.getHost().getVisual()).getParent().sceneToLocal(this.pivotInScene.x, this.pivotInScene.y));
            int translateIndex = transformPolicy.createPostTransform();
            int rotateIndex = transformPolicy.createPostTransform();
            int translateBackIndex = transformPolicy.createPostTransform();
            transformPolicy.setPostTranslate(translateIndex, -pivotInLocal.x, -pivotInLocal.y);
            transformPolicy.setPostTranslate(translateBackIndex, pivotInLocal.x, pivotInLocal.y);
            this.rotationIndices.put(part, rotateIndex);
        }
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        for (IVisualPart iVisualPart : this.getTargetParts()) {
            this.updateOperation(e, (IVisualPart<Node, ? extends Node>)iVisualPart);
            FXTransformPolicy transformPolicy = this.getTransformPolicy((IVisualPart<Node, ? extends Node>)iVisualPart);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals(iVisualPart);
            this.commit((AbstractTransactionPolicy)transformPolicy);
        }
    }

    protected boolean showIndicationCursor(boolean isControlDown) {
        if (isControlDown) {
            this.getCursorSupport().storeAndReplaceCursor(this.getRotateCursor());
            return true;
        }
        return false;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return this.showIndicationCursor(event.isControlDown());
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return this.showIndicationCursor(event.isControlDown());
    }

    private void updateOperation(MouseEvent e, IVisualPart<Node, ? extends Node> part) {
        FXTransformPolicy transformPolicy = this.getTransformPolicy(part);
        if (transformPolicy != null) {
            transformPolicy.setPostRotate(this.rotationIndices.get(part), this.computeRotationAngleCW(e, part));
        }
    }
}

