/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXPartUtils {
    public static Rectangle getUnionedVisualBoundsInScene(Collection<? extends IVisualPart<Node, ? extends Node>> parts) {
        Rectangle bounds = null;
        for (IVisualPart<Node, ? extends Node> iVisualPart : parts) {
            Rectangle boundsInScene = FX2Geometry.toRectangle((Bounds)((Node)iVisualPart.getVisual()).localToScene(((Node)iVisualPart.getVisual()).getLayoutBounds()));
            if (bounds == null) {
                bounds = boundsInScene;
                continue;
            }
            bounds.union(boundsInScene);
        }
        return bounds;
    }

    public static IViewer<Node> retrieveViewer(IDomain<Node> domain, Node target) {
        Map viewers = domain.getAdapters((TypeToken)new TypeToken<IViewer<Node>>(){});
        for (IViewer viewer : viewers.values()) {
            if (!viewer.isViewerVisual((Object)target)) continue;
            return viewer;
        }
        return null;
    }

    public static IVisualPart<Node, ? extends Node> retrieveVisualPart(IViewer<Node> viewer, Node target) {
        IRootPart targetPart = null;
        while (targetPart == null && target != null) {
            targetPart = (IVisualPart)viewer.getVisualPartMap().get(target);
            target = target.getParent();
        }
        if (targetPart == null) {
            targetPart = viewer.getRootPart();
        }
        return targetPart;
    }
}

